package com.bcxin.enums;

import lombok.AccessLevel;
import lombok.Getter;

@Getter(AccessLevel.PRIVATE)
public enum ActionStep {
    BeforeAction(0),
    ActionCore(1),
    AfterAction(2);

    private final int position;

    ActionStep(int position) {
        this.position = position;
    }

    public boolean executable(ActionStep executedStep) {
        if (this == null) {
            return true;
        }

        if (this.getPosition() == executedStep.getPosition()) {
            return true;
        }

        return false;
    }
}
