package com.bcxin.dtos;

import cn.myapps.common.controller.Resource;
import lombok.Getter;

@Getter
public class ExecuteActionResultDto {
    private final ActionResultType resultType;
    private final Resource data;

    public ExecuteActionResultDto(ActionResultType resultType, Resource data) {
        this.resultType = resultType;
        this.data = data;
    }

    public static enum ActionResultType {
        OK,
        Message,
        Error
    }

    public static ExecuteActionResultDto create(ActionResultType resultType, Resource data) {
        if(resultType==ActionResultType.OK && data==null) {
            data = Resource.ok(null);
        }

        return new ExecuteActionResultDto(resultType, data);
    }
}
