package com.bcxin;

import cn.myapps.components.HmacComponent;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.bcxin.components.DefinitionEditable;
import com.bcxin.intercepters.HmacAuthInterceptor;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.domains.repositories.HmacAuthRepository;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
public class RuntimeExConfig {

    @Bean
    @Primary
    public DefinitionEditable definitionEditable() {
        return new DefinitionEditable() {
            @Override
            public boolean editable() {
                return false;
            }
        };
    }

    @Bean
    public FilterRegistrationBean<WebStatFilter> filterRegistrationBean() {
        FilterRegistrationBean<WebStatFilter> filterRegistrationBean = new FilterRegistrationBean<WebStatFilter>();
        filterRegistrationBean.setFilter(new WebStatFilter());
        filterRegistrationBean.addUrlPatterns("/*");
        filterRegistrationBean.addInitParameter(WebStatFilter.PARAM_NAME_EXCLUSIONS,
                "/actuator/*,/v3/extends*,/api/core/monitor/druid/*,/upload/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico"
        );
        filterRegistrationBean.addInitParameter(WebStatFilter.PARAM_NAME_PROFILE_ENABLE, "true");
        return filterRegistrationBean;
    }

    @Bean
    public ServletRegistrationBean<StatViewServlet> druidServlet() {
        ServletRegistrationBean<StatViewServlet> reg = new ServletRegistrationBean<StatViewServlet>();
        reg.setServlet(new StatViewServlet());
        reg.addUrlMappings("/api/core/monitor/druid/*");
        reg.addInitParameter(StatViewServlet.PARAM_NAME_USERNAME, "admin");
        reg.addInitParameter(StatViewServlet.PARAM_NAME_PASSWORD, "bcxin#.20240702");
        return reg;
    }

    @Bean
    public FilterRegistrationBean corsFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        final CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true); // 允许cookies跨域
        config.addAllowedOriginPattern("*");
        //config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
        config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
        config.setMaxAge(18000L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
        config.addAllowedMethod("*");// 允许提交请求的方法，*表示全部允许
        source.registerCorsConfiguration("/**", config);
        filterRegistrationBean.setFilter(new CorsFilter(source));
        filterRegistrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);

        return filterRegistrationBean;
    }

        @Bean
    public HmacAuthInterceptor hmacAuthInterceptor(
            HmacAuthRepository hmacAuthRepository,
            StringRedisTemplate redisTemplate, JsonProvider jsonProvider,
            HmacComponent hmacComponent){
        return new HmacAuthInterceptor(hmacAuthRepository,redisTemplate,jsonProvider, hmacComponent);
    }
}
