package cn.myapps.webservice;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.webservice.fault.DocumentServiceFault;

public class WebServiceUtil {

	public static DomainVO validateDomain(String domainName) throws Exception {

		if (StringUtil.isBlank(domainName)) {
			throw new Exception("域名称不能为空.");
		} else {
			DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
			DomainVO vo = (DomainVO) dp.getDomainByName(domainName);
			if (vo == null) {
				throw new Exception("该域(" + domainName + ")不存在.");
			}
			return vo;
		}

	}

	public static Application validateApplication(String name)
			throws Exception {
		cn.myapps.designtime.application.service.ApplicationDesignTimeService appService = (cn.myapps.designtime.application.service.ApplicationDesignTimeService) DesignTimeServiceFactory.resolve(ApplicationService.class);
		List<Application> apps = appService.list(null,name);
		if (apps.isEmpty())
			throw new Exception("该应用(" + name + ")不存在.");
		return apps.get(0);
	}
	
	/**
	 * 校验应用，返回该应用对象
	 * @param applicationId
	 * @return
	 * @throws Exception
	 */
	public static Application validateApplicationById(String applicationId)
			throws Exception {
		cn.myapps.designtime.application.service.ApplicationDesignTimeService appService = (cn.myapps.designtime.application.service.ApplicationDesignTimeService) DesignTimeServiceFactory.resolve(ApplicationService.class);
		Application app = (Application) appService.findById(applicationId);
		if (app == null)
			throw new Exception("该应用(ID=" + applicationId + ")不存在.");
		return app;
	}
	
	/**
	 * 校验用户，返回该用户对象
	 * @param userId
	 * @return
	 * @throws Exception
	 */
	public static UserVO findUserWithValidate (String userId) 
			throws Exception {
		UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) userProcess.doView(userId);
		if(user == null){
			throw new Exception("该用户(ID=" + userId + ")不存在.");
		}
		return user;
	}
	
	/**
	 * 校验部门，返回该部门对象
	 * @param depId
	 * @return
	 * @throws Exception
	 */
	public static DepartmentVO findDepartmentWithValidate (String depId)
			throws Exception {
		DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
		DepartmentVO vo = (DepartmentVO) process.doView(depId);
		if (vo == null){
			throw new Exception("该部门(ID=" + depId + ")不存在.");
		}
		return vo;
	}
	
	/**
	 * 校验角色，返回该角色对象
	 * @param roleId
	 * @return
	 * @throws Exception
	 */
	public static cn.myapps.common.model.role.Role findRoleWithValidate (String roleId)
			throws Exception {
		cn.myapps.designtime.role.service.RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
		cn.myapps.common.model.role.Role vo = (cn.myapps.common.model.role.Role) roleService.findById(roleId);
		if (vo == null){
			throw new Exception("该角色(ID=" + roleId + ")不存在.");
		}
		return vo;
	}
	
	public static void validateDocument(Document doc,ParamsTable params,WebUser user,String applicationId) throws DocumentServiceFault{
		
		try {
			DocumentProcess docProcess = RunTimeServiceManager.documentProcess(applicationId);
			
			Collection<ValidateMessage> errors = docProcess.doValidate(doc,
					params, user);
			if (errors != null && errors.size() > 0) {
				StringBuffer msg = new StringBuffer();
				for (Iterator<ValidateMessage> iter = errors.iterator(); iter
						.hasNext();) {
					ValidateMessage err = (ValidateMessage) iter.next();
					msg.append(err.getFieldname()).append(":").append(err.getErrmessage()).append(";");
				}
				if(msg.length()>0){
					throw new DocumentServiceFault(msg.toString());
				}
			}
		} catch (DocumentServiceFault e) {
			throw e;
		} catch (Exception e) {
			throw new DocumentServiceFault(e.getMessage());
		}
		
	}
}
