package cn.myapps.util;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.activity.ActivityType;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Option;

import java.util.List;
import java.util.Map;

import static com.jayway.jsonpath.JsonPath.parse;

public class ParamsTableUtil {
    public static ParamsTable parseAndMergeActionB_A(ParamsTable params, String actId, String content, boolean isBeforeAction) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL);
        DocumentContext parse = parse(content, configuration);

        Map<String, Object> items = parse.read("$.document.items");
        if (items != null) {
            for (Map.Entry<String, Object> entry : items.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                params.setParameter(key, value);
            }
        }

        Map<String, Object> document = parse.read("$.document");
        if (document != null) {
            for (Map.Entry<String, Object> entry : document.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Object oldVal = params.getParameter(key);
                if (value instanceof String) {
                    if (!cn.myapps.common.util.StringUtil.isBlank(String.valueOf(value))) {
                        params.setParameter(key, value);
                    }
                } else {
                    params.setParameter(key, value);
                }
            }
        }

        List<String> selects = parse.read("$._selects");
        if (selects != null)
            params.setParameter("_selects", cn.myapps.common.util.StringUtil.unite(selects.toArray()));

        List<String> subSelects = parse.read("$.subSelects");
        if (subSelects != null) {
            params.setParameter("subSelects", cn.myapps.common.util.StringUtil.unite(subSelects.toArray()));
        }

        List<String> nextNodeIds = parse.read("$.nextNodeIds");
        if (nextNodeIds != null)
            params.setParameter("_nextids", cn.myapps.common.util.StringUtil.unite(nextNodeIds.toArray()));

        String attitude = parse.read("$.attitude");
        if (!cn.myapps.common.util.StringUtil.isBlank(attitude))
            params.setParameter("attitude", attitude);
        String signature = parse.read("$.signatureJson");
        if (!StringUtil.isBlank(signature)) {
            params.setParameter("_signature", signature);
        }

        List<Map<String, String>> submitTo = parse.read("$.submitTo");
        if (submitTo != null) {
            params.setParameter("submitTo", submitTo.toString());
        }

        if(isBeforeAction) {
            //自定义按钮不做额外的重计算
            Object obj = params.getParameter("actType");
            if (obj != null) {
                int actType = Integer.parseInt((String) obj);
                if (ActivityType.NOTHING == actType) {
                    ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
                    Activity act = activityService.findById(actId);
                    if (act == null) {
                        params.setParameter("isFromRefresh", true);
                    }
                }
            }
        }

        return params;
    }
}
