package cn.myapps.support.sms.teemlink;

import java.net.MalformedURLException;
import java.net.URL;

import cn.myapps.webservice.client.TeemLinkSMS;
import cn.myapps.webservice.client.TeemLinkSMSServiceLocator;

public final class TeemLinkSMSManager {

	private TeemLinkSMS teemLinkSendService = null;
	
	private static final String WEBSERVICE_URL = "http://sms.teemlink.com/sms/services/SMSService";
	
	private static TeemLinkSMSManager instance = null;
	
	private TeemLinkSMSManager() {
		cn.myapps.webservice.client.TeemLinkSMSService service = new TeemLinkSMSServiceLocator();
		try {
			teemLinkSendService = service.getSMSService(getWebServiceURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static TeemLinkSMSManager getInstance() {
		synchronized (TeemLinkSMSManager.class) {
			if (instance == null) instance = new TeemLinkSMSManager();
		}
		return instance;
	}
	
	private URL getWebServiceURL() throws MalformedURLException {
		return new URL(WEBSERVICE_URL);
	}
	
	public TeemLinkSMS getService() {
		return teemLinkSendService;
	}
	
}
