package cn.myapps.support.sms.teemlink;

import java.util.Collection;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.support.sms.IReceiver;
import cn.myapps.webservice.client.TeemLinkSMS;
import cn.myapps.webservice.model.SimpleReceive;

/**
 * 获取回复短信者 实现类
 * 
 * @author tom
 * 
 */
public final class TeemLinkReceiver implements IReceiver {

	private TeemLinkSMS teemLinkService = null;
	
	public TeemLinkReceiver() {
		teemLinkService = TeemLinkSMSManager.getInstance().getService();
	}
	
	public String receiveMessage() throws Exception {

		DomainProcess dprocess = AuthTimeServiceManager.domainRuntimeService();;
		Collection<DomainVO> domains = dprocess.getAllDomain();

		if (domains == null)
			return null;

		for (DomainVO domain : domains) {
			// 到短信平台获取回复短信
			SimpleReceive receiveMsgs[] = teemLinkService.receiveMsgs(
					domain.getSmsMemberCode(), domain.getSmsMemberPwd());

			if (receiveMsgs == null || receiveMsgs.length == 0)
				continue;
		}
		return null;
	}
	
}
