package cn.myapps.support.sms;

import cn.myapps.support.sms.teemlink.TeemLinkReceiver;
import cn.myapps.support.sms.teemlink.TeemLinkSender;


public class MessageManager {

	private IValidator validator;

	private static MessageManager ins = null;

	private MessageManager(IValidator validator) {
		this.validator = validator;
	}

	public static MessageManager getInstance(IValidator validator) {
		if (!(ins != null && ins.validator == validator))
			ins = new MessageManager(validator);
		return ins;

	}
	
	public static MessageManager getInstance() {
		if (ins == null)
			ins = new MessageManager(new Validator(null, null));
		return ins;
	}
	
	public IReceiver getReceiver() throws Exception {
		if (validate()) {
//			return (IReceiver) getObject("receiver");
			return new TeemLinkReceiver();
		}
		return null;
	}

	private boolean validate() throws Exception {
		return validator.validate();
	}

	public ISender getSender() throws Exception {
		
//		String smsSender = PropertyUtil.get("sms.sender");
//		
//		if("GsmModen".equals(smsSender)){
//			return new GsmModemSender();
//		}else{
			if (validate()) {
	//			return (ISender) getObject("sender");
				return new TeemLinkSender();
			}
//		}
		return null;
	}

	public IValidator getValidator() {
		return validator;
	}
}
