package cn.myapps.support.sms;

/**
 * 短信发送接口,定义单条发送和批量发送两形式的方法
 * 
 * @author Chris
 * 
 */
public interface ISender extends IMessage {

	/**
	 * 发送单条短信息
	 * 
	 * @param recTelephone
	 *            接收者号码
	 * @param content
	 *            短信内容
	 * @return 发送状态,0:发送成功,负数:发送失败
	 * @throws Exception
	 */
	public int sendMessage(String recTelephone, String content)
			throws Exception;

	/**
	 * 发送单条短信息
	 * 
	 * @param recTelephone
	 *            接收者号码
	 * @param content
	 *            短信内容
	 * @param replyCode
	 *            回复码
	 * @return 发送状态,0:发送成功,负数:发送失败
	 * @throws Exception
	 */
	public int sendMessage(String recTelephone, String content, String replyCode)
			throws Exception;

	/**
	 * 批量发送短信息
	 * 
	 * @param recTels
	 *            接收者号码列表
	 * @param content
	 *            短信内容
	 * @return 发送状态,0:发送成功,负数:发送失败
	 * @throws Exception
	 */
	public int battchSendMessage(String[] recTels, String content)
			throws Exception;

	/**
	 * 批量发送短信息
	 * 
	 * @param recTels
	 *            接收者号码列表
	 * @param content
	 *            短信内容
	 * @param replyCode
	 *            回复码
	 * @return 发送状态,0:发送成功,负数:发送失败
	 * @throws Exception
	 */
	public int battchSendMessage(String[] recTels, String content,
			String replyCode) throws Exception;

}
