package cn.myapps.scheduler;

import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Aspect
@Component
public class TriggerAspectImpl implements TriggerAspect {

    /**
     * 查询任务的时间间隔
     */
    private static final long INTERVAL = 60*1000L;

    @After("execution(* cn.myapps.scheduler.SchedulerProcessBean.insertTrigger(..))")
    @Override
    public void addTrigger(JoinPoint point) throws Exception {
        TriggerVO triggerVO = (TriggerVO) point.getArgs()[0];
        boolean isInsert = (boolean) point.getArgs()[1];
        if(isInsert){
            TriggerProcess process = RunTimeServiceManager.triggerProcess(triggerVO.getApplicationId());
            process.doCreate(triggerVO);
        }
        long nextExecutorTime = INTERVAL+new java.util.Date().getTime();
        if(triggerVO.getJobType()!=TriggerVO.JOB_TYPE_ISCRITP_TASK&&triggerVO.getDeadline()<nextExecutorTime){
            addTriggerOnce(triggerVO,triggerVO.getApplicationId());
            return;
        }
    }

    @After("execution(* cn.myapps.scheduler.SchedulerProcessBean.deleteTrigger(..))")
    @Override
    public void cancelTrigger(JoinPoint point) throws Exception{
        TriggerVO triggerVO = (TriggerVO) point.getArgs()[0];
        boolean isDelete = (boolean) point.getArgs()[1];
        String jobName = triggerVO.getId();
        String jobGroupName = triggerVO.getApplicationId();
        SchedulerUtil.cancelJob(jobName, jobGroupName);
        TriggerProcess process = RunTimeServiceManager.triggerProcess(triggerVO.getApplicationId());
        if(isDelete){
            process.doRemove(triggerVO.getId());
        }else {
            triggerVO.setState(TriggerVO.STATE_STOP);
            process.doUpdate(triggerVO);
        }
    }

    @After("execution(* cn.myapps.scheduler.SchedulerProcessBean.updateTrigger(..))")
    @Override
    public void updateTrigger(JoinPoint point) throws Exception {
        TriggerVO triggerVO = (TriggerVO) point.getArgs()[0];
        TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess(triggerVO.getApplicationId());
        TriggerVO trigger = (TriggerVO)triggerProcess.selectByToken(triggerVO.getToken());
        if(trigger!=null){
            triggerVO.setId(trigger.getId());
            triggerVO.setRunTimes(trigger.getRunTimes());
            triggerProcess.doUpdate(triggerVO);
        }
    }

    public static void addTriggerOnce(TriggerVO triggerVO, String application) throws Exception {
        try {
            String jobName = triggerVO.getId();
            String jobGroupName = triggerVO.getApplicationId();
            String triggerName = triggerVO.getId();;
//			String triggerGroupName = "";
            //不可以为空字符串
            String triggerGroupName = triggerVO.getApplicationId();
            String cron = "0/3 * * * * ?";
            //只执行一次，但是时间不确定，所以设定好执行时间
            Date startTime = new Date(triggerVO.getDeadline());
            Map<String,Object> map = new HashMap();
            map.put("triggervo",triggerVO);
            map.put("application",triggerVO.getApplicationId());
            SchedulerUtil.triggerJobOnce(jobName, jobGroupName, triggerName, triggerGroupName, TriggerExecutor.class,map,startTime);
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }

    }

}
