package cn.myapps.scheduler;

import cn.myapps.common.util.SpringApplicationContextUtil;
import org.quartz.*;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

import java.util.Date;
import java.util.Map;

public class SchedulerUtil {

	private static SchedulerFactoryBean getFactory() {
		SchedulerFactoryBean factory = SpringApplicationContextUtil.getBean(SchedulerFactoryBean.class);
		return factory;
	}

	public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName,
			Class<? extends Job> jobClass, String cron,Map<?, ?> dataMap) {
		addJobWithContextDataMap(jobName, jobGroupName, triggerName, triggerGroupName, jobClass, cron, dataMap);
	}

	public static void addJobWithContextDataMap(String jobName, String jobGroupName, String triggerName,
			String triggerGroupName, Class<? extends Job> jobClass, String cron, Map<?, ?> dataMap) {
		try {
			JobDataMap newJobDataMap = new JobDataMap(dataMap);
			Scheduler sched = getFactory().getScheduler();

			// 任务名，任务组，任务执行类

			JobDetail jobDetail = null;
			if (dataMap == null) {
				jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).usingJobData(newJobDataMap).storeDurably(true).build();
			} else {
				jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).usingJobData(newJobDataMap)
						.storeDurably(true).build();
			}
			if (!sched.checkExists(JobKey.jobKey(jobName, jobGroupName))) {
				// 触发器
				TriggerBuilder<Trigger> triggerBuilder = TriggerBuilder.newTrigger();
				// 触发器名,触发器组
				triggerBuilder.withIdentity(triggerName, triggerGroupName);
				triggerBuilder.startNow();
				// 触发器时间设定
				triggerBuilder.withSchedule(CronScheduleBuilder.cronSchedule(cron));
				// 创建Trigger对象
				CronTrigger trigger = (CronTrigger) triggerBuilder.usingJobData(newJobDataMap).build();

				// 调度容器设置JobDetail和Trigger
				sched.scheduleJob(jobDetail, trigger);
			} else {
				sched.addJob(jobDetail, true);
			}

			// 启动
			if (!sched.isShutdown()) {
				sched.start();
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

	}

	public static void triggerJobOnce(String jobName, String jobGroupName, String triggerName, String triggerGroupName,
									  Class<? extends Job> jobClass, Map<?, ?> dataMap, Date startTime) {
		try {
			//审批超时 自动节点 子流程节点 恢复挂起流程 平台模式回调任务 每次只需要调用一次定时任务
			Scheduler sched = getFactory().getScheduler();
			JobDataMap newJobDataMap = new JobDataMap(dataMap);
			// 任务名，任务组，任务执行类
			JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).usingJobData(newJobDataMap).build();

			SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1)
					.withRepeatCount(1);

			//放进来不一定马上执行，所以改用startAt(startTime)
			Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).startAt(startTime)
					.withSchedule(builder).usingJobData(newJobDataMap).build();
			sched.scheduleJob(jobDetail, trigger);

			// 启动
			if (!sched.isShutdown()) {
				sched.start();
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	public static void cancelJob(String jobName, String jobGroupName) {
		Scheduler sched = getFactory().getScheduler();
		try {
			sched.pauseJob(JobKey.jobKey(jobName, jobGroupName));
			sched.deleteJob(JobKey.jobKey(jobName, jobGroupName));
		} catch (SchedulerException e) {
			e.printStackTrace();
		}
	}

	public static void destroy() {
		try {
			getFactory().destroy();
		} catch (SchedulerException e) {
			e.printStackTrace();
		}
	}
}
