package cn.myapps.scheduler;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.sysconfig.LoginConfig;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.runtime.notice.PersonalMessageMode;
import cn.myapps.support.sms.ISender;
import cn.myapps.support.sms.MessageManager;
import cn.myapps.support.sms.Validator;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.mail.EmailUtil;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import java.util.Collection;
import java.util.Date;

public class NotificationSendPasswordMessageJob extends Job {

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        PropertyUtil.reload("passwordLegal");
        String loginPasswordNotice = PropertyUtil.get(LoginConfig.LOGIN_UPDATE_NOTICE);
        String loginNoticeMethod = PropertyUtil.get(LoginConfig.LOGIN_NOTICE_METHOD);
        String loginNoticeAuthor = PropertyUtil.get(LoginConfig.LOGIN_NOTICE_AUTHOR);
        String loginNoticeContent = PropertyUtil.get(LoginConfig.LOGIN_NOTICE_CONTENT);
        String loginPasswordMaxage = PropertyUtil.get(LoginConfig.LOGIN_PASSWOR_MAXAGE);
        long now = new Date().getTime();
        long passwordAgeNotice = Long.parseLong(loginPasswordNotice) * 24 * 3600 * 1000;
        long passwordAge = Long.parseLong(loginPasswordMaxage) * 24 * 3600 * 1000;
        String[] method = loginNoticeMethod.split(",");
        String content = loginNoticeContent;
        try {
            UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            DomainProcess domainProcess = (DomainProcess) ProcessFactory.createProcess(DomainProcess.class);
            Collection<DomainVO> domains = domainProcess.queryDomainsByStatus(1);
            for (DomainVO domain : domains) {
                long userCount = userProcess.countByDomain(domain.getId());
                int userPageSize = 2000;
                int maxUserPageIndex = (int) (userCount / userPageSize + (userCount % userPageSize > 0 ? 1 : 0));
                for (int index = 1; index <= maxUserPageIndex; index++) {
                    int page = index;
                    Collection<UserVO> users = userProcess.queryByDomain(domain.getId(), page, userPageSize);
                    for (UserVO user : users) {
                        if(user.getStatus() == 1){
                            if (loginNoticeAuthor.equals("0")) {
                                long lastPassTime = user.getLastModifyTime().getTime();
                                if ((lastPassTime + passwordAge) < now) {
                                    //禁用该用户
                                    userProcess.updateUserLockFlag(user.getLoginno(), 0);
                                }
                                if ((lastPassTime + passwordAgeNotice) < now) {
                                    for (int i = 0; method.length > i; i++) {
                                        WebUser tuser = new WebUser(user);
                                        if (method[i].equals("1")) {
                                            MessageManager manager = MessageManager.getInstance(new Validator(user.getDomainid(), ""));
                                            ISender sender = manager.getSender();
                                            sender.sendMessage(user.getTelephone(), content);
                                        }
                                        if (method[i].equals("2")) {
                                            PersonalMessageMode personMessageMode = new PersonalMessageMode();
                                            personMessageMode.sendMessageToUser(user.getId(),  user.getId(), "密码过期通知", content);
                                        }
                                        if (method[i].equals("3")) {
                                            EmailUtil eu = new EmailUtil("", tuser);
                                            eu.sendEmailBySystemUserForTranspond(user.getEmail(), "密码过期通知", content);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    PersistenceUtils.closeSessionAndConnection();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
