package cn.myapps.runtime.workflow.flowMonitor.controller;

import org.jfree.util.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.workflow.flowMonitor.service.INodeMonitorService;
import net.sf.json.JSONObject;

@Controller
@RequestMapping("/api/runtime/{applicationId}/monitors/workflows")
public class NodeMonitorController {
	@Autowired
	private INodeMonitorService nodeMonitorServiceImpl;
	
	@GetMapping(value="/nodes",produces="application/json;charset=utf-8")
	public ResponseEntity<?> doList(@PathVariable String applicationId,
			@RequestParam String domainId,
			@RequestParam String _currpage,
			@RequestParam String _pagelines,
			@RequestParam(required=false,defaultValue="") String _orderby,
			@RequestParam(required=false,defaultValue="") String _flowName,
			@RequestParam String _status,
			@RequestParam String _flowIndex,
			@RequestParam(required=false,defaultValue="") String _auditor,
			@RequestParam(required=false,defaultValue="") String _actionTimeBegin,
			@RequestParam(required=false,defaultValue="") String _actionTimeEnd,
			@RequestParam(required=false,defaultValue="") String _summary) throws Exception {
		try{
			JSONObject json = new JSONObject();
			json.put("domainId", domainId);
			json.put("_currpage", _currpage);
			json.put("_pagelines", _pagelines);
			json.put("_orderby", _orderby);
			json.put("_flowName", _flowName);
			json.put("_status", _status);
			json.put("_auditor", _auditor);
			json.put("_actionTimeBegin", _actionTimeBegin);
			json.put("_actionTimeEnd", _actionTimeEnd);
			json.put("_summary", _summary);
			json.put("_flowIndex", _flowIndex);
			return ResponseEntity.ok(nodeMonitorServiceImpl.getNodeList(applicationId, json));
		}catch (Exception e) {
			Log.error(e.getMessage());
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
}
