package cn.myapps.runtime.workflow.flowMonitor.controller;

import java.util.Collection;

import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Controller
@RequestMapping("/api/runtime/monitors/workflows/nav/")
public class NavigationController extends AbstractRuntimeController {
	
	/**
	 * 获取流程导航树
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/flow_trees")
	@ResponseStatus(HttpStatus.OK)
	public Resource getflowTrees() throws Exception {
		try {
			BillDefiDesignTimeService billDefiService = DesignTimeServiceManager.billDefiDesignTimeService();
			WebUser user = getSuperUser();
			String superUserId = user != null? user.getId():null;
			return success("success",billDefiService.getFlowTree(superUserId));
		} catch (Exception e) {
			return error(500,e.getMessage(),null);
		}
	}
	
	/**
	 * 获取软件导航树
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/application_trees")
	@ResponseStatus(HttpStatus.OK)
	public Resource getApplicationTrees() throws Exception {
		try {
			WebUser user = getSuperUser();
			String superUserId = user != null? user.getId():null;
			
			SuperUserDesignTimeService superUserService = DesignTimeServiceManager.superUserDesignTimeService();
			
			SuperUserVO superUser = superUserService.doView(superUserId);
			
			Collection<Application> applications = superUser.getApplicationList();

			JSONArray appArray = new JSONArray();

			for(Application application : applications) {
				
				//if(!application.isActivated()) continue;
				
				JSONObject appJson = new JSONObject();
				appJson.put("id",application.getId());
				appJson.put("name",application.getName());
				appJson.put("type", "application");
				appArray.add(appJson);
			}
			return success("success",appArray);
		} catch (Exception e) {
			return error(500,e.getMessage(),null);
		}
	}
	
	/**
	 * 获取该超级管理员或开发者管理的企业域
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/domain_list")
	@ResponseStatus(HttpStatus.OK)
	public Resource getDomainList() throws Exception {
		try {
			DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
			Collection<DomainVO> collection = dp.getAllDomain();
			JSONArray jsonArray = new JSONArray();
			for(DomainVO domain : collection){
				JSONObject domainJson = new JSONObject();
				domainJson.put("id",domain.getId());
				domainJson.put("name",domain.getName());
				domainJson.put("type", "domain");
				jsonArray.add(domainJson);
			}
			return success("success",jsonArray);
		} catch (Exception e) {
			return error(500,e.getMessage(),null);
		}
	}
	
	/**
	 * 获取当前登录的特权用户（开发者、超级管理员）
	 * @return
	 */
	private WebUser getSuperUser(){
		WebUser user = AuthTimeServiceManager.getAdminUser(request);
		return user;
	}
}
