package cn.myapps.runtime.workflow.flowMonitor.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.workflow.flowMonitor.service.IFlowStatisticsService;
import cn.myapps.runtime.workflow.flowMonitor.utils.ResponseUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Controller
@RequestMapping("/api/runtime/{applicationId}/monitors/workflows/statistics")
public class FlowStatisticsController{

	@Autowired
	private IFlowStatisticsService flowStatisticsService;
	
	@GetMapping(value="/instances")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> currentView(@PathVariable String applicationId,
			@RequestParam String domainId,
			@RequestParam(required=false) String startTime,
			@RequestParam(required=false) String endTime) throws Exception {
		try{
			List<Map<String,Object>> datas = flowStatisticsService.currentView(applicationId,domainId,startTime,endTime);
			if(datas.isEmpty()){
					JSONObject jsonObject = new JSONObject();
					return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",jsonObject));
			}else{
					return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",datas));
			}
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}

	@GetMapping(value="/photo")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> flowInstancePhoto(@RequestParam String instanceId) throws Exception {
		try{
			String base = flowStatisticsService.photoToBase64(instanceId);
			return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",base));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
	
	@GetMapping(value="/instance_distributions")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> flowDistribution(@PathVariable String applicationId,
			@RequestParam String domainId,
			@RequestParam(required=false) String startTime,
			@RequestParam(required=false) String endTime) throws Exception {
		try{
			return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",flowStatisticsService.flowDistribution(applicationId,domainId,startTime,endTime)));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
	
	@GetMapping(value="/instance_times")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> flowTimes(@PathVariable String applicationId,
			@RequestParam String domainId,
			@RequestParam(required=false) String startTime,
			@RequestParam(required=false) String endTime) throws Exception {
		try{
			return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",flowStatisticsService.flowTimes(applicationId,domainId,startTime,endTime)));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
	
	@GetMapping(value="/node_times")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> NodeTimes(@PathVariable String applicationId,
			@RequestParam String domainId,@RequestParam String flowName) throws Exception {
		try{
			return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",flowStatisticsService.NodeTimes(applicationId,domainId,flowName)));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
	
	@GetMapping(value="/complete_types")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> completeStatus(@PathVariable String applicationId,
			@RequestParam String domainId,
			@RequestParam(required=false) String startTime,
			@RequestParam(required=false) String endTime) throws Exception {
		try{
			return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",flowStatisticsService.completeStatus(applicationId,domainId,startTime,endTime)));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
	
	@GetMapping(value="/back_instances")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> flowBack(@PathVariable String applicationId,
			@RequestParam String domainId,
			@RequestParam(required=false) String startTime,
			@RequestParam(required=false) String endTime) throws Exception {
		try{
			return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",flowStatisticsService.flowBack(applicationId,domainId,startTime,endTime)));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
	
	@GetMapping(value="/back_nodes")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<?> nodeBack(@PathVariable String applicationId,
			@RequestParam String domainId,@RequestParam String flowName) throws Exception {
		try{
			return ResponseEntity.ok(ResponseUtils.setResource(0,"ok",flowStatisticsService.nodeBack(applicationId,domainId,flowName)));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
}
