package cn.myapps.runtime.workflow.flowMonitor.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.workflow.flowMonitor.service.IFlowMonitorService;
import cn.myapps.runtime.workflow.service.WorkflowRunTimeService;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryVO;
import cn.myapps.runtime.workflow.storage.runtime.intervention.ejb.FlowInterventionVO;
import net.sf.json.JSONObject;

@Controller
@RequestMapping("/api/runtime/{applicationId}/monitors/workflows")
public class FlowMonitorController extends AbstractRuntimeController {
	
	@Autowired
	private IFlowMonitorService flowMonitorServiceImpl;
	
	@Autowired
	private WorkflowRunTimeService workflowService;
	
	/**
	 * 获取流程实例列表
	 * @param applicationId
	 * @param domainId
	 * @param _currpage
	 * @param _pagelines
	 * @param _orderby
	 * @param _flowName
	 * @param _status
	 * @param _flowIndex
	 * @param _initiator
	 * @param _firstProcessTimeBegin
	 * @param _firstProcessTimeEnd
	 * @param _summary
	 * @param _initiatorDeptId
	 * @return
	 * @throws Exception
	 */
	@GetMapping(value="/instances")
	@ResponseStatus(HttpStatus.OK)
	public ResponseEntity<Resource> doList(@PathVariable String applicationId,
			@RequestParam String domainId,
			@RequestParam String _currpage,
			@RequestParam String _pagelines,
			@RequestParam(required=false,defaultValue="") String _orderby,
			@RequestParam(required=false,defaultValue="") String _flowName,
			@RequestParam String _status,
			@RequestParam String _flowIndex,
			@RequestParam(required=false,defaultValue="") String _initiator,
			@RequestParam(required=false,defaultValue="") String _firstProcessTimeBegin,
			@RequestParam(required=false,defaultValue="") String _firstProcessTimeEnd,
			@RequestParam(required=false,defaultValue="") String _summary,
			@RequestParam(required=false,defaultValue="") String _initiatorDeptId) throws Exception {
		try{		
			JSONObject json = new JSONObject();
			json.put("domainId", domainId);
			json.put("_currpage", _currpage);
			json.put("_pagelines", _pagelines);
			json.put("_orderby", _orderby);
			json.put("_flowName", _flowName);
			json.put("_status", _status);
			json.put("_initiatorId", _initiator);
			json.put("_firstProcessTimeBegin", _firstProcessTimeBegin);
			json.put("_firstProcessTimeEnd", _firstProcessTimeEnd);
			json.put("_summary", _summary);
			json.put("_flowIndex", _flowIndex);
			json.put("_initiatorDeptId", _initiatorDeptId);
			return ResponseEntity.ok(flowMonitorServiceImpl.getFlowList(applicationId, json));
		}catch (Exception e) {
			return new ResponseEntity<Resource>(new Resource(500,"server innernal error"),HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
	
	/**
	 * 获取流程历史
	 * @param applicationId
	 * 			软件id
	 * @param instanceId
	 * 			流程实例id
	 * @return
	 * 			流程催办历史对象的集合
	 * @throws Exception
	 */
	@GetMapping("/instances/{instanceId}/historys")
	@ResponseStatus(HttpStatus.OK)
	public Resource getHistorys(@PathVariable String applicationId, @PathVariable String instanceId) throws Exception {
		try {
			List<FlowHistoryVO> his = workflowService.getHistorys(applicationId, instanceId);
			List<FlowHistoryVO> cur = workflowService.getCurrents(applicationId, instanceId);
			his.addAll(cur);
			return success("success",his);
		} catch (Exception e) {
			return error(500,e.getMessage(),null);
		}
	}
	
	/**
	 * 获取流程实例信息
	 * @param applicationId
	 * 			软件id
	 * @param id
	 * 			流程实例id
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/instances/{id}")
	@ResponseStatus(HttpStatus.OK)
	public Resource getInstanceInfo(@PathVariable String applicationId, @PathVariable String id) throws Exception {
		try {
			FlowInterventionVO flowInterventionVO = flowMonitorServiceImpl.getInstance(applicationId, id);
			return success("success",flowInterventionVO);
		} catch (Exception e) {
			return error(500,e.getMessage(),null);
		}
	}
}
