package cn.myapps.runtime.workflow.controller;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.workflow.notification.ejb.NotificationJob;
import cn.myapps.runtime.workflow.notification.ejb.NotificationProcess;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.Collection;
import java.util.Iterator;

@Api(tags = "定时任务执行模块")
@Component
@RequestMapping("/api/runtime/job")
public class JobController extends AbstractRuntimeController {

    public final static Logger LOG = LoggerFactory.getLogger(NotificationJob.class);

    public final static Object _lock = new Object();

    @RequestMapping("notifyOverDue")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = " 流程催办提醒", notes = " 流程催办提醒")
    public Resource notifyOverDueAuditors(){
        new Thread(()->{
            synchronized (_lock) {
                try{
                    LOG.debug("{}", "********************* Notification Job Start ********************");
                    ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
                    Collection<Application> applications = appService.list(null,null);
                    try {
                        for (Iterator<Application> iterator = applications.iterator(); iterator.hasNext();) {
                            Application application = (Application) iterator.next();
                            if (application.testDB()) {
                                try {
                                    NotificationProcess process = RunTimeServiceManager.notificationProcess(application.getId());
                                    process.notifyOverDueAuditors();
                                } catch (Exception e) {
                                    continue;
                                } finally {
                                    PersistenceUtils.closeSessionAndConnection();
                                }
                            }
                        }
                    } catch (Exception e) {
                        LOG.error("Notification Job Error: ", e);
                    }

                    LOG.debug("{}", "********************* Notification Job End ********************");
                }catch (Exception e){

                }
            }
        }).start();
        return success("ok", null);
    }
}
