package cn.myapps.runtime.workflow.controller;

import java.util.Collection;
import java.util.HashMap;

import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.workflow.analyzer.AnalyzerProcess;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(tags = "流程仪表模块")
@Component
@RequestMapping(path = "/api/runtime/{applicationId}", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AnalyzerController extends AbstractRuntimeController {

    @PostMapping(value="/Consuming")
    @ApiOperation(value = "流程仪表盘查询", notes = "流程仪表盘查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId",value = "软件id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource doConsuming(@PathVariable String applicationId, @RequestBody String content) throws Exception {

        JSONObject jsonObject = JSONObject.parseObject(content);

        String showMode = (String)jsonObject.get("showMode");
        String dateRange = (String)jsonObject.get("dateRange");
        ParamsTable params = getParams();
        params.setParameter("select",jsonObject.get("select"));
        params.setParameter("startdate",jsonObject.get("startdate"));
        params.setParameter("enddate",jsonObject.get("enddate"));
        params.setParameter("showMode",jsonObject.get("showMode"));
        params.setParameter("dateRange",jsonObject.get("dateRange"));
        IUser user = getUser();

        Collection<HashMap> datas;
        try {
            AnalyzerProcess process = RunTimeServiceManager.analyzerProcess(applicationId);
            datas =  process.getConsuming(params, dateRange, showMode, user);
            return success( "success", datas);
        } catch (Exception e) {
            e.printStackTrace();
            return success( e.getLocalizedMessage(), null);
        }
    }
}
