package cn.myapps.runtime.system.monitor.util;

import java.io.File;
import java.io.FileWriter;
import java.util.List;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;

import cn.myapps.scheduler.Job;

@PersistJobDataAfterExecution // 当job执行结束，持久化job信息到数据库
@DisallowConcurrentExecution // 保证job的唯一性（单例）
public class SystemMonitorClear extends Job {

	public static int executeTime=1000*60*30;
	
	@Override
	protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
		try {
			
			String contextPath=System.getProperty("java.io.tmpdir");
			//1天的数据量,每分钟执行2次写入的操作，数据量有
			int count=2*60*24*1;
			List<String> lists= SystemMonitorUtil.readFile(contextPath + File.separator + "systemMonitor.txt");
			int beginIndex=0;
			int endIndex=lists.size()-1;
			if(lists.size()>count){
				FileWriter writer=new FileWriter(contextPath + File.separator + "systemMonitor.txt");
				writer=new FileWriter(contextPath + File.separator + "systemMonitor.txt",true);
				beginIndex=endIndex-count;
				lists=lists.subList(beginIndex, endIndex);
				//写入
				for (String string : lists) {
					writer.write(string+", ");
					writer.flush();
				}
				writer.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

}
