package cn.myapps.runtime.rest.workflow.service;

import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import org.springframework.web.bind.annotation.RequestParam;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.document.model.IDocument;

import java.util.List;

/**
 * 流程信息查询service
 * @author Steven
 *
 */
public interface WorkflowQueryService {

	/**
	 * 根据流程实例id获取文档当前的流程状态
	 * @param applicationId
	 * 		软件id
	 * @param instanceId
	 * 		流程实例id
	 * @return
	 * @throws Exception
	 */
	JSONObject queryWorkflow(String applicationId, String instanceId) throws Exception;

	/**
	 * 获取文档提交面板
	 * @param applicationId
	 * 			软件id
	 * @param docId
	 * 			文档id
	 * @param params
	 * 			参数表
	 * @return
	 * @throws Exception
	 */
	JSONObject submissionPanels(String applicationId, IDocument doc, WebUser user, String flowId, String instanceId, ParamsTable params) throws Exception;
	
	/**
	 * 获取文档回退面板
	 * @param applicationId
	 * 			软件id
	 * @param instanceid
	 * 			流程实例id
	 * @param user
	 * 			用户
	 * @return
	 * @throws Exception
	 */
	JSONObject backPanels(String applicationId, String instanceid, WebUser user) throws Exception;
	
	/**
	 * 获取指定节点(任务)信息
	 * @param instanceid
	 * @param user
	 * @return
	 * @throws Exception
	 */
	JSONObject taskInfo(String instanceid, WebUser user,String applicationId) throws Exception;
	
	/**
	 * 获取指定节点(任务)信息数量
	 * @param instanceid
	 * @param user
	 * @return
	 * @throws Exception
	 */
	JSONObject taskNum(String instanceid, WebUser user,String applicationId) throws Exception;
	
	/**
	 * 获取指定节点审批人
	 * @param instanceid
	 * @param nodeRTId
	 * @param applicationId
	 * @return
	 * @throws Exception
	 */
	JSONObject getNodeRT(String instanceid, String nodeRTId,String applicationId) throws Exception;
	
	/**
	 * 获取指定节点审批人
	 * @param user
	 * @param params
	 * @param applicationId
	 * @param nodeId
	 * @param flowId
	 * @param instanceId
	 * @return
	 * @throws Exception
	 */
	JSONObject getAllActor(WebUser user,ParamsTable params,String applicationId,String nodeId,String flowId,String instanceId) throws Exception;

	/**
	 * 获取文档提交面板
	 * @param applicationId
	 * 			软件id
	 * 			文档id
	 * 			参数表
	 * @return
	 * @throws Exception
	 */
	List<NodeRT> remindPanels(String applicationId, WebUser user, String instanceId) throws Exception;
}
