package cn.myapps.runtime.rest.workflow.service;

import java.io.File;
import java.util.List;

import javax.servlet.ServletContext;

import cn.myapps.common.util.PropertyUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryVO;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryService;

@Service
public class WorkflowHistoryServiceImpl implements WorkflowHistoryService {
	
	@Autowired 
	private ServletContext servletContext;

	@Override
	public List<FlowHistoryVO> getHistorys(String applicationId, String flowInstanceId) throws Exception {
		FlowHistoryService hisProcess = new FlowHistoryServiceImpl( applicationId);

		List<FlowHistoryVO> historys = (List<FlowHistoryVO>) hisProcess.getFlowHistorysByDocId(flowInstanceId);

		return historys;
	}

	@Override
	public File getFlowPhoto(String applicationId, String instanceId,String dateTime) throws Exception {
		String path = PropertyUtil.getPath();
		String url = path+File.separator + "uploads" + File.separator + "billflow" + File.separator +dateTime+File.separator+ instanceId +".jpg";
		File file = new File(url);
		return file;
	}
}
