package cn.myapps.runtime.rest.workflow.service;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;

import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryVO;

/**
 * 流程历史service
 * @author Steven
 *
 */
public interface WorkflowHistoryService {
	
	/**
	 * 根据流程实例id获取当前实例下的流程历史对象的集合
	 * @param applicationId
	 * 		软件id
	 * @param instanceId
	 * 		流程实例id
	 * @return
	 * 		流程历史对象的集合
	 */
	List<FlowHistoryVO> getHistorys(String applicationId,String instanceId) throws Exception;
	
	/**
	 * 根据流程实例id获取流程图
	 * @param applicationId
	 * 		软件id
	 * @param instanceId
	 * 		流程实例id
	 * @return
	 * 		流程历史对象的集合
	 */
	File getFlowPhoto(String applicationId,String instanceId,String dateTime) throws Exception;
	
}
