package cn.myapps.runtime.rest.workflow.service;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.document.model.PureDocument;

import java.util.List;

/**
 * 流程执行service
 * @author Happy
 *
 */
public interface WorkflowExecuteService {

	/**
	 * 启动流程
	 * @param doc
	 * @param flowId
	 * @param user
	 * @param params
	 * @return
	 */
	void start(IDocument doc, WebUser user,ParamsTable params,String flowId)throws Exception;

	/**
	 * 提交流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param currNodeId
	 * @param nextNodeIds
	 * @param flowType
	 * @param comment
	 * @throws Exception
	 */
	void submit(IDocument doc,WebUser user, ParamsTable params,String currNodeId,
				String[] nextNodeIds, String flowType, String comment) throws Exception;

	/**
	 * 驳回流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param currNodeId
	 * @param nextNodeIds
	 * @param flowType
	 * @param comment
     * @Param flowId
     * @Param applicationId
	 * @throws Exception
	 */
	void back(IDocument doc,WebUser user, ParamsTable params,String currNodeId,
			  String[] nextNodeIds, String flowType, String comment, String flowId ,String applicationId) throws Exception;

	/**
	 * 撤回流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @throws Exception
	 */
	void retract(IDocument doc,WebUser user,ParamsTable params,String applicationId) throws Exception;

	/**
	 * 恢复流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @throws Exception
	 */
	void recovery(IDocument doc,WebUser user,ParamsTable params,String applicationId) throws Exception;

	/**
	 * 终止流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @throws Exception
	 */
	void terminate(IDocument doc,WebUser user,ParamsTable params,String applicationId) throws Exception;

	/**
	 * 挂起流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @throws Exception
	 */
	void suspend(IDocument doc,WebUser user,ParamsTable params,String applicationId) throws Exception;

	/**
	 * 开启自由流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @param comment
	 * @param nextUserId
	 * @throws Exception
	 */
	void startFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment,
				   String nextUserId) throws Exception;

	/**
	 * 自由流程提交
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @param comment
	 * @param nextUserId
	 * @throws Exception
	 */
	void submitFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment,
					String nextUserId) throws Exception;

	/**
	 * 回退自由流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @param comment
	 * @param nextUserId
	 * @throws Exception
	 */
	void backFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment,
				   String nextUserId) throws Exception;

	/**
	 * 结束自由流程
	 * @param doc
	 * @param user
	 * @param params
	 * @param applicationId
	 * @param comment
	 * @throws Exception
	 */
	void completeFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment) throws Exception;

	/**
	 * 添加节点审批人（加签）
	 * @param params
	 * @param user
	 * @param applicationId
	 * @param doc
	 * @param auditorList
	 * @throws Exception
	 */
	IDocument updateAuditor(ParamsTable params, WebUser user, String applicationId,String instanceId,List<String> userIds) throws Exception;

	/**
	 * 流程协办
	 * @param applicationId
	 * @param instanceId
	 * @param user
	 * @param attitude
	 * @return
	 */
	String doFlowAssist(String applicationId, String instanceId, String attitude, WebUser user) throws Exception;

	/**
	 * 流程协办加签
	 * @param applicationId
	 * 		软件id
	 * @param docId
	 * 		文档id
	 * @param userIds
	 * 		加签用户id集合
	 * @param user
	 * 		当前登陆用户
	 * @return
	 * @throws Exception
	 */
	String addCoAuditor(String applicationId, String docId, List<String> userIds, WebUser user) throws Exception;


	/**
	 * 流程催办
	 * @param user
	 * 			用户
	 * @param applicationid
	 * 			软件id
	 * @param instanceId
	 * 			流程实例
	 * @param nodertIds
	 * 			节点id集合
	 * @param reminderContent
	 * 			提醒意见
	 * @return
	 * @throws Exception
	 */
	PureDocument reminderWorkflow(WebUser user, String applicationid, String instanceId,
								  String[] nodertIds, String reminderContent) throws Exception;

	/**
	 * 更新流程节点审批人
	 * @param params
	 * @param user
	 * @param applicationId
	 * @param doc
	 * @param auditorList
	 * @throws Exception
	 */
	IDocument updateApprovers(ParamsTable params, WebUser user, String applicationId,String instanceId,List<String> userIds) throws Exception;
	/**
	 * 删除流程
	 * @param docID
	 * @throws Exception
	 */

	/**
	 * 添加/补签意见
	 * @param applicationId
	 * 		软件id
	 * @param instanceId
	 * 		流程实例id
	 * @param comments
	 * 		补签的意见
	 * @param user
	 * 		当前登陆用户
	 * @return
	 * @throws Exception
	 */
	String doFlowSupplement(String applicationId, String instanceId, String comments, WebUser user) throws Exception;

	void deleteFlow(String docID,String applicationId) throws Exception;
}
