package cn.myapps.runtime.rest.workflow.controller;

import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.dynaform.document.model.PureDocument;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.workflow.service.WorkflowQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;

import java.util.List;

/**
 * 流程信息查询控制器
 * 
 * @author steven
 *
 */

@Api(tags = "流程查询模块")
@Controller
@RequestMapping(path = "/api/rest/bpm/query", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class WorkflowQueryController extends AbstractRESTController {

	@Autowired
	@Qualifier("workflowQueryServiceImpl")
	WorkflowQueryService service;

	/**
	 * 获取文档当前流程状态
	 * @param applicationId
	 * @param instanceId
	 * @param accessToken
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "流程状态", notes = "流程状态")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string")
	})
	@GetMapping("/states")
	@ResponseStatus(HttpStatus.OK)
	public Resource startqueryWorkflow(@RequestParam String applicationId, @RequestParam String instanceId,
									   @RequestParam String accessToken)throws Exception {
		JSONObject result = service.queryWorkflow(applicationId, instanceId);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(result));
	}

	/**
	 * 获取文档的流程提交面板
	 * @param accessToken
	 * @param applicationId
	 * @param instanceId
	 * @param flowId
	 * @param userCode
	 * @param postBody
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "获取流程提交面板", notes = "获取流程提交面板")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "flowId",value = "流程定义模型Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "body",dataType = "string"),
		@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string")
	})
	@PostMapping("/submission")
	@ResponseStatus(HttpStatus.OK)
	public Resource submissionPanels(@RequestParam String accessToken,@RequestParam String applicationId, @RequestParam String instanceId,
									 @RequestParam String flowId, @RequestParam String userCode, @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);
		JSONObject result = service.submissionPanels(applicationId, doc, user, flowId, instanceId, getParams());
		result.put("instanceId", instanceId);
		return success("success", result);
	}

	/**
	 * 获取文档的流程回退面板
	 * @param applicationId
	 * @param instanceId
	 * @param accessToken
	 * @param userCode
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "获取流程回退面板", notes = "获取流程回退面板")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string")
	})
	@PostMapping("/back")
	@ResponseStatus(HttpStatus.OK)
	public Resource backPanels(@RequestParam String applicationId, @RequestParam String instanceId,
							   @RequestParam String accessToken, @RequestParam String userCode) throws Exception {
		JSONObject result = service.backPanels(applicationId, instanceId, getUser());
		result.put("instanceId", instanceId);
		return success("success", result);
	}

	/**
	 * 获取流程催办面板
	 * @param accessToken
	 * @param applicationId
	 * @param instanceId
	 * @param userCode
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "获取流程催办面板", notes = "获取流程催办面板")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string")
	})
	@GetMapping("/remindpanel")
	@ResponseStatus(HttpStatus.OK)
	public Resource remindPanel(@RequestParam String accessToken,@RequestParam String applicationId, @RequestParam String instanceId,
								@RequestParam String userCode) throws Exception {
		WebUser user = getUser();
		List<NodeRT> nodeRTS = service.remindPanels(applicationId, user, instanceId);
		JSONArray result = new JSONArray();
		for (NodeRT nodert:nodeRTS){
			net.sf.json.JSONObject object = new net.sf.json.JSONObject();
			object.put("id", nodert.getNodeid());
			object.put("name",nodert.getName());
			result.add(object);
		}
		return success("success", result);
	}

	/**
	 * 获取请求发起人在指定节点(任务)信息
	 * @param accessToken
	 * @param userCode
	 * @param instanceId
	 * @param applicationId
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "获取指定节点信息", notes = "获取指定节点信息")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string")
	})
	@GetMapping("/taskInfo")
	@ResponseStatus(HttpStatus.OK)
	public Resource taskInformation(@RequestParam String accessToken,@RequestParam String userCode,
									@RequestParam String instanceId,@RequestParam String applicationId) throws Exception {
		JSONObject result = service.taskInfo(instanceId, getUser(), applicationId);
		return success("success", result);
	}

	/**
	 * 获取请求发起人在指定节点(任务)数量
	 * @param accessToken
	 * @param userCode
	 * @param instanceId
	 * @param applicationId
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "获取指定节点数量", notes = "获取指定节点数量")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string")
	})
	@GetMapping("/taskNum")
	@ResponseStatus(HttpStatus.OK)
	public Resource taskNum(@RequestParam String accessToken,@RequestParam String userCode,
							@RequestParam String instanceId,@RequestParam String applicationId) throws Exception {
		JSONObject result = service.taskNum(instanceId, getUser(), applicationId);
		return success("success", result);
	}

	/**
	 * 获取指定实例节点审批人
	 * @param accessToken
	 * @param instanceId
	 * @param nodeRTId
	 * @param applicationId
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "获取指定实例节点审批人", notes = "获取指定实例节点审批人")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "nodeRTId",value = "节点实例Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string")
	})
	@GetMapping("/nowActor")
	@ResponseStatus(HttpStatus.OK)
	public Resource getActorRT(@RequestParam String accessToken, @RequestParam String instanceId,
							   @RequestParam String nodeRTId,@RequestParam String applicationId) throws Exception {
		JSONObject result = service.getNodeRT(instanceId, nodeRTId, applicationId);
		return success("success", result);
	}

	/**
	 * 获取指定节点候选审批人
	 * @param accessToken
	 * @param applicationId
	 * @param nodeId
	 * @param flowId
	 * @param instanceId
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "获取指定节点候选审批人", notes = "获取指定节点候选审批人")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "nodeId",value = "节点Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "flowId",value = "流程模板Id",required = true,paramType = "query",dataType = "string")
	})
	@GetMapping("/allActor")
	@ResponseStatus(HttpStatus.OK)
	public Resource getActorbyNode(@RequestParam String accessToken,@RequestParam String applicationId,@RequestParam String nodeId, 
								   @RequestParam String flowId,@RequestParam String instanceId,@RequestParam String userCode) throws Exception{

		JSONObject result = new JSONObject();
		WebUser user = getUser();
		ParamsTable params = getParams();
		result = service.getAllActor(user, params, applicationId, nodeId, flowId, instanceId);
		return success("success", result);
	}
}