package cn.myapps.runtime.rest.workflow.controller;

import cn.myapps.runtime.dynaform.document.model.IDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.dynaform.document.model.PureDocument;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.workflow.service.WorkflowExecuteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;

import java.util.List;

import static com.jayway.jsonpath.JsonPath.parse;

/**
 * 流程执行控制器
 * @author Happy
 *
 */
@Api(tags = "流程执行模块")
@Controller
@RequestMapping(path = "/api/rest/bpm/runtime", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class WorkflowExecuteController extends AbstractRESTController {
	
	@Autowired
	@Qualifier("workflowExecuteServiceImpl")
	WorkflowExecuteService service;

	/**
	 * 发起流程
	 * @param accessToken 访问令牌
	 * @param applicationId 应用id
	 * @param flowId 流程定义id
	 * @param userCode 用户编码(用户账号)
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@ApiOperation(value = "发起流程", notes = "启动和初始化流程")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "flowId",value = "流程定义模型Id",required = true,paramType = "query",dataType = "string"),
		@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "body",dataType = "string")
	})
	@PostMapping("/start")
	@ResponseStatus(HttpStatus.OK)
	public Resource start(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
						  @RequestParam String flowId, @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);
		service.start(doc,user,getParams(),flowId);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 提交流程
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param flowType 流程类型 @see FlowType
	 * @param currNodeId 当前节点的节点定义对象Id
	 * @Param instanceId 流程实例Id
	 * @param comment 审批意见
	 * @param nextNodeIds 下一节点的节点定义对象的集合(数组)
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/submission")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "发起流程", notes = "提交和审批流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "flowType",value = "流程类型(FlowType)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "currNodeId",value = "当前节点的节点定义对象Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "nextNodeIds",value = "下一节点的节点定义对象的集合(数组)",required = true,paramType = "query",dataType = "string",allowMultiple = true),
			@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "body",dataType = "string")
	})
	public Resource submit(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
						   @RequestParam String flowType, @RequestParam String currNodeId ,@RequestParam String instanceId,
						   @RequestParam(required = false) String comment ,@RequestParam String[] nextNodeIds,
						   @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);
		doc.setState(instanceId);
		service.submit(doc,user,getParams(),currNodeId,nextNodeIds,flowType,comment);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 流程驳回
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param flowType 流程类型 @see FlowType
	 * @param currNodeId 当前节点的节点定义对象Id
	 * @param instanceId 流程实例Id
	 * @param comment 审批意见
	 * @param nextNodeIds 下一节点的节点定义对象的集合(数组)
	 * @param flowId 流程定义id
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/back")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "流程驳回",notes = "驳回流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "flowType",value = "流程类型",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "currNodeId",value = "当前节点的节点定义对象Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "comment",value = "审批意见",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "nextNodeIds",value = "下一节点的节点定义对象的集合(数组)",required = true,paramType = "query",dataType = "string",allowMultiple = true),
			@ApiImplicitParam(name = "flowId",value = "流程定义Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "body",dataType = "string")
	})
	public Resource back(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
						 @RequestParam String flowType, @RequestParam String currNodeId ,@RequestParam String instanceId,
						 @RequestParam(required = false) String comment ,@RequestParam String[] nextNodeIds, @RequestParam String flowId,
						 @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);
		doc.setState(instanceId);
		service.back(doc,user,getParams(),currNodeId,nextNodeIds,flowType,comment,flowId,applicationId);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 催办流程
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param instanceId 流程实例Id
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/remind")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "催办流程",notes = "催办流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "reminderContent",value = "催办意见",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "query",dataType = "string")
	})
	public Resource reminderWorkflow(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
									 @RequestParam String instanceId, @RequestParam String reminderContent,@RequestBody String[] content) throws Exception {
		WebUser user = getUser();
//		DocumentContext parse = JsonPath.parse(userIds, configur
//		ation);
		PureDocument doc = service.reminderWorkflow(user, applicationId, instanceId, content, reminderContent);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

    /**
     * 回撤流程
     * @param accessToken 访问令牌
     * @param applicationId 应用Id
     * @param userCode 用户编码(用户账号)
     * @param instanceId 流程实例Id
     * @param postBody 请求包体内容
     * @return
     * @throws Exception
     */
	@PostMapping("/retracement")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "回撤流程",notes = "流程回撤")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "body",dataType = "string")
	})
	public Resource retreat(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
                            @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = getUser();
        PureDocument doc = parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        service.retract(doc,getUser(),getParams(),applicationId);
        return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
    }

    /**
     * 恢复流程
     * @param accessToken 访问令牌
     * @param applicationId 应用Id
     * @param userCode 用户编码(用户账号)
     * @param instanceId 流程实例Id
     * @param postBody 请求包体内容
     * @return
     * @throws Exception
     */
    @PostMapping("/recovery")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "恢复流程",notes = "恢复流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "query",dataType = "string")
	})
    public Resource recovery(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
                            @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = getUser();
        PureDocument doc = parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        service.recovery(doc,getUser(),getParams(),applicationId);
        return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
    }

    /**
     * 终止流程
     * @param accessToken 访问令牌
     * @param applicationId 应用Id
     * @param userCode 用户编码(用户账号)
     * @param instanceId 流程实例Id
     * @param postBody 请求包体内容
     * @return
     * @throws Exception
     */
    @PostMapping("/termination")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "终止流程", notes = "终止流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码(用户账号)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "body",dataType = "string")
	})
    public Resource terminate(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
                              @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = getUser();
        PureDocument doc = parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        service.terminate(doc,getUser(),getParams(),applicationId);
        return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
    }

    /**
     * 挂起流程
     * @param accessToken 访问令牌
     * @param applicationId 应用Id
     * @param userCode 用户编码(用户账号)
     * @param instanceId 流程实例Id
     * @param postBody 请求包体内容
     * @return
     * @throws Exception
     */
    @PostMapping("/suspend")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "挂起流程",notes = "挂起流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体内容",required = true,paramType = "body",dataType = "string")
	})
    public Resource suspend(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
                            @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = getUser();
        PureDocument doc = parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        service.suspend(doc,getUser(),getParams(),applicationId);
        return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
    }

	/**
	 * 开启自由流程
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param comment 审批意见
	 * @param nextUserCode 下个审批人的UserCode
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/startFree")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "开启自由流程", notes = "开启自由流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码(用户账号)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "comment",value = "审批意见",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "nextUserCode",value = "下个审批人的UserCode",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体的内容",required = true,paramType = "body",dataType = "string")
	})
    public Resource startFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
							  @RequestParam(required = false) String comment, @RequestParam String nextUserCode,
							  @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);

		UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
		String nextUserId = userProcess.findUserIdByAccount(nextUserCode);

		service.startFree(doc,getUser(),getParams(),applicationId,comment,nextUserId);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 提交自由流程
	 * @param accessToken 访问令牌
	 * @param applicationId 应用id
	 * @param userCode 用户编码(用户账号)
	 * @param comment 审批意见
	 * @param nextUserCode 下个审批人的UserCode
	 * @param parentId 业务数据父文档Id
	 * @param instanceId 流程实例Id
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/submissionFree")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "提交自由流程", notes = "提交自由流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码(用户账号)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "comment",value = "审批意见",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "nextUserCode",value = "下个审批人的UserCode",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "parentId",value = "父id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "实例id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体的内容",required = true,paramType = "body",dataType = "string")
	})
	public Resource submitFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
							   @RequestParam(required = false) String comment, @RequestParam String nextUserCode, @RequestParam(required = false) String parentId,
							   @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);
		doc.setParent(parentId);
		doc.setState(instanceId);

		UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
		String nextUserId = userProcess.findUserIdByAccount(nextUserCode);

		service.submitFree(doc,getUser(),getParams(),applicationId,comment,nextUserId);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 回退自由流程
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param comment 审批意见
	 * @param nextUserId 下个审批人Id
	 * @param instanceId 流程实例Id
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/backFree")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "回退自由流程", notes = "回退自由流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码(用户账号)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "comment",value = "审批意见",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "nextUserId",value = "下个审批人的Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体的内容",required = true,paramType = "body",dataType = "string")
	})
	public Resource backFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
							   @RequestParam(required = false) String comment, @RequestParam String nextUserId,
							   @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);
		doc.setState(instanceId);
		service.backFree(doc,getUser(),getParams(),applicationId,comment,nextUserId);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 流程协办加签
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param instanceId 流程实例Id
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/assist/addition")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "流程协办加签",notes = "流程协办加签")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userIds",value = "请求包体(用户id集合)",required = true,paramType = "body",dataType = "string")
	})
	public Resource addCoAuditor(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
								 @RequestParam String instanceId,@RequestBody String userIds) throws Exception {
		WebUser user = getUser();
//		DocumentContext parse = JsonPath.parse(userIds, configuration);
		List<String> idList = parse(userIds).json();
		String info = service.addCoAuditor(applicationId,instanceId,idList,user);
		return success("success", info);
	}

	/**
	 * 流程协办
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param instanceId 流程实例Id
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/assist")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "流程协办",notes = "流程协办")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "comment",value = "审批意见",required = true,paramType = "query",dataType = "string")
	})
	public Resource doFlowAssist(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
								 @RequestParam String instanceId,@RequestParam String comment) throws Exception {
		WebUser user = getUser();
		String info = service.doFlowAssist(applicationId,instanceId,comment,user);
		return success("success", info);
	}

	/**
	 * 结束自由流程(归档)
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param comment 审批意见
	 * @param instanceId 流程实例Id
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/completeFree")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "结束自由流程", notes = "结束自由流程(归档)")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码(用户账号)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "comment",value = "审批意见",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体的内容",required = true,paramType = "body",dataType = "string")
	})
	public Resource completeFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
								 @RequestParam(required = false) String comment, @RequestParam String instanceId,
								 @RequestBody String postBody) throws Exception {
		WebUser user = getUser();
		PureDocument doc = parseDocument(postBody, applicationId, user);
		doc.setState(instanceId);
		service.completeFree(doc,getUser(),getParams(),applicationId,comment);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 更改流程节点审批人
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param instanceId 流程实例Id
	 * @param auditorList 审批人列表
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/auditor")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "更改审批人",notes = "更改流程节点审批人")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码(用户账号)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "auditorList",value = "审批人列表",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "请求包体的内容",required = true,paramType = "body",dataType = "string")
	})
	public Resource updateAuditor(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
								  @RequestParam String instanceId,@RequestBody String userIds) throws Exception{
		WebUser user = getUser();
		List<String> auditorList = parse(userIds).json();
//		PureDocument doc = parseDocument(postBody, applicationId, user);
//		doc.setState(instanceId);
//		DocumentContext parse = JsonPath.parse(postBody, configuration);
//		List<String> auditorList = parse.read("$.auditorList");
		IDocument doc =  service.updateAuditor(getParams(),getUser(),applicationId,instanceId,auditorList);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 编辑当前节点审批人
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param instanceId 流程实例Id
	 * @param auditorList 审批人列表
	 * @param postBody 请求包体内容
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/approvers")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "编辑当前节点审批人",notes = "编辑当前节点审批人")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码(用户账号)",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "postBody",value = "审批人列表",required = true,paramType = "body",dataType = "string")
	})
	public Resource updateApprovers(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
									@RequestParam String instanceId, @RequestBody String userIds) throws Exception{
		WebUser user = getUser();
		List<String> auditorList = parse(userIds).json();
//		PureDocument doc = parseDocument(postBody, applicationId, user);
//		doc.setState(instanceId);
//		DocumentContext parse = JsonPath.parse(postBody, configuration);
//		List<String> auditorList = parse.read("$.auditorList");
		IDocument doc =  service.updateApprovers(getParams(),getUser(),applicationId,instanceId,auditorList);
		return success("success", cn.myapps.util.json.JsonTmpUtil.fromObject(doc.getStateLabelInfo()));
	}

	/**
	 * 添加/补签意见
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param userCode 用户编码(用户账号)
	 * @param instanceId 流程实例Id
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/supplement")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "添加/补签意见",notes = "添加/补签意见")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "userCode",value = "用户编码",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "instanceId",value = "流程实例Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "content",value = "补签意见",required = true,paramType = "query",dataType = "string")
	})
	public Resource supplement(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode,
							   @RequestParam String instanceId, @RequestParam String content) throws Exception {
		WebUser user = getUser();
//		DocumentContext parse = JsonPath.parse(userIds, configur
//		ation);
		String result = service.doFlowSupplement(applicationId, instanceId, content, user);
		return success("success",result );
	}

	/**
	 * 删除流程
	 * @param accessToken 访问令牌
	 * @param applicationId 应用Id
	 * @param docId 文档Id
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/delete")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "删除流程",notes = "删除流程")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "accessToken",value = "访问令牌",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "applicationId",value = "应用Id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "docId",value = "文档Id",required = true,paramType = "query",dataType = "string")
	})
	public Resource deleteFlow(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String docId) throws Exception{
		service.deleteFlow(docId, applicationId);
		return success("success", "删除成功");
	}
}
