package cn.myapps.runtime.rest.util;

import java.sql.Connection;

import cn.myapps.authtime.common.dao.ConnectionManager;
import cn.myapps.runtime.rest.department.dao.AbstractDepartmentDAO;
import cn.myapps.runtime.rest.department.dao.DB2DepartmentDAO;
import cn.myapps.runtime.rest.department.dao.DmSQLDepartmentDAO;
import cn.myapps.runtime.rest.department.dao.MssqlDepartmentDAO;
import cn.myapps.runtime.rest.department.dao.MysqlDepartmentDAO;
import cn.myapps.runtime.rest.department.dao.OracleDepartmentDAO;
import cn.myapps.runtime.rest.department.dao.PostgreSQLDepartmentDAO;
import cn.myapps.runtime.rest.user.dao.AbstractUserDAO;
import cn.myapps.runtime.rest.user.dao.DB2UserDAO;
import cn.myapps.runtime.rest.user.dao.DmSQLUserDAO;
import cn.myapps.runtime.rest.user.dao.MssqlUserDAO;
import cn.myapps.runtime.rest.user.dao.MysqlUserDAO;
import cn.myapps.runtime.rest.user.dao.OracleUserDAO;
import cn.myapps.runtime.rest.user.dao.PostgreSQLUserDAO;

public class DaoManager {

	public static AbstractUserDAO getUserDAO(Connection conn) throws Exception {
		String dbType = ConnectionManager.dbType;
		if ("MSSQL".equals(dbType)) {
			return new MssqlUserDAO(conn);
		} else if ("ORACLE".equals(dbType)) {
			return new OracleUserDAO(conn);
		} else if ("DB2".equals(dbType)) {
			return new DB2UserDAO(conn);
		} else if ("MYSQL".equals(dbType)) {
			return new MysqlUserDAO(conn);
		}else if ("POSTGRESQL".equals(dbType)) {
			return new PostgreSQLUserDAO(conn);
		}else if ("DM".equals(dbType)) {
			return new DmSQLUserDAO(conn);
		}
		return null;
	}
	
	public static AbstractDepartmentDAO getDepartmentDAO(Connection conn) throws Exception {
		String dbType = ConnectionManager.dbType;
		if ("MSSQL".equals(dbType)) {
			return new MssqlDepartmentDAO(conn);
		} else if ("ORACLE".equals(dbType)) {
			return new OracleDepartmentDAO(conn);
		} else if ("DB2".equals(dbType)) {
			return new DB2DepartmentDAO(conn);
		} else if ("MYSQL".equals(dbType)) {
			return new MysqlDepartmentDAO(conn);
		} else if ("POSTGRESQL".equals(dbType)) {
			return new PostgreSQLDepartmentDAO(conn);
		} else if ("DM".equals(dbType)) {
			return new DmSQLDepartmentDAO(conn);
		}
		return null;
	}

}
