package cn.myapps.runtime.rest.user.service;

import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.dao.ConnectionManager;
import cn.myapps.runtime.rest.user.dao.AbstractUserDAO;
import cn.myapps.runtime.rest.user.model.User;
import cn.myapps.runtime.rest.util.DaoManager;

@Service("bpmUserService")
public class UserServiceImpl implements UserService  {

	public AbstractUserDAO getDAO() throws Exception {
		return DaoManager.getUserDAO(ConnectionManager.getConnection());
	}
	
	@Override
	public String add(User user) throws Exception {
		return getDAO().add(user);
	}
	
	@Override
	public User find(String acount) throws Exception {
		return getDAO().find(acount);
	}
	
	@Override
	public String update(JSONObject jsonObject) throws Exception {
		return getDAO().update(jsonObject);
	}
	
	@Override
	public String delete(String acount) throws Exception {
		return getDAO().delete(acount);
	}

}
