package cn.myapps.runtime.rest.security.service;

import io.jsonwebtoken.ExpiredJwtException;

/**
 * AccessToken服务接口
 * 用于生成AccessToken,以及验证AccessToken
 * @author zhanbo
 */
public interface AccessTokenService {

    /**
     * 验证AccessToken
     * @param accessToken 通行令牌
     * @param secretKey 解密密钥
     * @return
     */
    Boolean checkAccessToken(String accessToken,String secretKey) throws ExpiredJwtException,Exception;

    /**
     * 生成AccessToken
     * @param secret 开发者密钥
     * @param secretKey 解密密钥
     * @return
     */
    String generateAccessToken(String secret,String secretKey);
}
