package cn.myapps.runtime.rest.security.controller;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.security.service.AccessTokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/**
 * accessToken 生成控制器
 */
@Api(tags = "生成accessToken执行模块")
@RestController
@RequestMapping({"/api/rest","/rest"})
public class AccessTokenController extends AbstractRESTController {

    private static final String SECRET_KEY = "teemlink_obpm";

    @Autowired
    private AccessTokenService accessTokenService;

    /**
     * 生成accessToken Restful接口
     * @param secret
     * @return
     */
    @GetMapping("/accessToken")
    @ApiOperation(value = "生成accessToken Restful接口", notes = "生成accessToken Restful接口")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "secret",value = "secret",required = true,paramType = "query",dataType = "string")
	})
    public Resource accessToken(@RequestParam String secret) {
        String accessToken = accessTokenService.generateAccessToken(secret,SECRET_KEY);
        JSONObject object = new JSONObject();
        object.put("accessToken",accessToken);
        return success("success",object);
    }
}
