package cn.myapps.runtime.rest.department.service;

import java.util.Collection;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.runtime.rest.department.model.Department;

public interface DepartmentService {

	/**
	 * 新增部门
	 * @param dept
	 * @return
	 * @throws Exception
	 */
	String add(Department dept) throws Exception;
	
	/**
	 * 查找部门
	 * @param id 部门ID
	 * @return
	 * @throws Exception
	 */
	Department find(String id) throws Exception;
	
	/**
	 * 更新部门
	 * @param jsonObject 
	 * @return
	 * @throws Exception
	 */
	String update(JSONObject jsonObject) throws Exception;
	
	/**
	 * 删除部门
	 * @param id
	 * @return
	 * @throws Exception
	 */
	String delete(String id) throws Exception;
	
	/**
	 * 获取部门信息（多个）
	 * @param id
	 * @return
	 * @throws Exception
	 */
	Collection<Department> get(String id) throws Exception;
}
