package cn.myapps.runtime.rest.department.dao;

import java.sql.Connection;
import java.sql.SQLException;

public class PostgreSQLDepartmentDAO extends AbstractDepartmentDAO implements DepartmentDAO {

	public PostgreSQLDepartmentDAO(Connection conn) throws Exception {
		super();
		if (conn != null) {
			try {
				this.schema = conn.getMetaData().getURL().trim().toUpperCase();
				if (this.schema.indexOf("?USE") > 0) {
					this.schema = this.schema.substring(this.schema
							.lastIndexOf("/") + 1, this.schema.indexOf("?USE"));
				} else {
					this.schema = this.schema.substring(this.schema
							.lastIndexOf("/") + 1);
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
		}
	}
}
