package cn.myapps.runtime.rest.department.controller;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.department.model.Department;
import cn.myapps.runtime.rest.department.service.DepartmentService;

@Controller(value="bpmDepartmentController")
@RequestMapping(path = "/rest/bpm/department")
public class DepartmentController extends AbstractRESTController {

	@Autowired
	@Qualifier("bpmDepartmentService")
	DepartmentService service;
	
	/**
	 * 新增部门
	 * @param accessToken
	 * @param postBody
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/save")
	@ResponseStatus(HttpStatus.OK)
	public Resource save(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
		Department dept = parseDepartment(postBody);
		String response = service.add(dept);
		return success("created", response);
	}
	
	/**
	 * 通过部门ID查找部门信息
	 * @param accessToken
	 * @param postBody
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/find")
	@ResponseStatus(HttpStatus.OK)
	public Resource find(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
		DocumentContext parse = JsonPath.parse(postBody, configuration);
		String id = parse.read("$.id");
		Department dept = service.find(id);
		JSONObject deptJSON = new JSONObject();
		deptJSON.put("DepartmentInfo", dept);
		return success("ok", deptJSON);
	}
	
	/**
	 * 更新部门信息
	 * @param accessToken
	 * @param postBody
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/update")
	@ResponseStatus(HttpStatus.OK)
	public Resource update(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
		JSONObject jsonObject=JSONObject.parseObject(postBody);
		String response = service.update(jsonObject);
		return success("ok", response);
	}
	
	/**
	 * 删除部门
	 * @param accessToken
	 * @param postBody
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/delete")
	@ResponseStatus(HttpStatus.OK)
	public Resource delete(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
		DocumentContext parse = JsonPath.parse(postBody, configuration);
		String account = parse.read("$.id");
		String response = service.delete(account);
		return success("ok", response);
	}
	
	/**
	 * 获取部门信息（多个）
	 * @param accessToken
	 * @param postBody
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/get")
	@ResponseStatus(HttpStatus.OK)
	public Resource get(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
		DocumentContext parse = JsonPath.parse(postBody, configuration);
		String id = parse.read("$.id");
		Collection<Department> dept = service.get(id);
		JSONObject deptJSON = new JSONObject();
		deptJSON.put("DepartmentList", dept);
		return success("ok", deptJSON);
	}
}
