package cn.myapps.runtime.report.service;

import java.util.List;

import cn.myapps.runtime.report.dao.RuntimeOpenQueryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import cn.myapps.common.exception.CommonException;
import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.common.model.report.Report;


@Service
public class RuntimeOpenQueryServiceImpl implements RuntimeOpenQueryService {

    @Autowired
    private RuntimeOpenQueryDao openQueryDao;

    public List<QueryColumnInfo> getQueryColumnInfos(String sql, String dbDriver, String dbUrl, String dbUser, String dbPass ) throws CommonException {
        return openQueryDao.getQueryColumnInfos(sql, dbDriver, dbUrl, dbUser, dbPass);
    }

    @Override
    public List<QueryColumnInfo> getProcedureColumnsInfos(String procedureScript, String dbDriver, String dbUrl, String dbUser, String dbPass) throws Exception {
        return openQueryDao.getProcedureColumnsInfos(procedureScript, dbDriver, dbUrl, dbUser, dbPass);
    }

    public void generateDynamicReportDataSource(Report report, String sql, String dbDriver, String dbUrl, String dbUser, String dbPass ) throws CommonException {
        openQueryDao.generateDynamicReportDataSource(report, sql, dbDriver, dbUrl, dbUser, dbPass);
    }

    @Override
    public void generateDynamicReportDataSourceByProcedure(Report report, String procedureScript, String dbDriver, String dbUrl, String dbUser, String dbPass) throws Exception {
        openQueryDao.generateDynamicReportDataSourceByProcedure(report,procedureScript, dbDriver, dbUrl, dbUser, dbPass);
    }
}

