package cn.myapps.runtime.report.service;

import java.util.Collection;
import java.util.List;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.CommonException;
import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.runtime.common.service.RunTimeFileService;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.macro.runner.IRunner;

/**
 * @author Happy
 *
 */
public interface ReportService extends RunTimeFileService<Report> {

	/**
	 * 根据数据文档对象的ID标识查找数据文档对象.
	 *
	 * @param pk
	 *            数据文档对象ID标识.
	 * @return 数据文档对象.
	 * @throws Exception
	 */
	public Report doView(String pk) throws Exception;

	/**
	 * 获取查询结果列信息
	 * @author laiq
	 * @param sql
	 * @param dataSourceName
	 * @param applicationId
	 * @param user
	 * @param report
	 * @param params
	 * @return
	 * @throws CommonException
	 */
	public List<QueryColumnInfo> getQueryColumnInfos(String sql, String dataSourceName, String applicationId, IUser user, Report report, ParamsTable params ) throws Exception;

	/**
	 *      根据报表Id产生报表HTML返回
	 * @author laiq
	 * @param reportId
	 * @param user
	 * @param params
	 * @throws CommonException
	 */
	public String generateDynamicReportByReportId(String reportId, IUser user, ParamsTable params ) throws Exception;

	/**
	 *      根据报表Id产生excel文件，并返回路径
	 * @author laiq
	 * @param reportId
	 * @param user
	 * @param params
	 * @throws CommonException
	 */
	public String generateExcelByReportId(String reportId, IUser user, ParamsTable params ) throws Exception;

	/**
	 *      根据报表Id产生pdf文件，并返回路径
	 * @author laiq
	 * @param reportId
	 * @param user
	 * @param params
	 * @throws CommonException
	 */
	public String generatePdfByReportId(String reportId, IUser user, ParamsTable params ) throws Exception;

	public String getQueryString(ParamsTable params, IUser user, Document sDoc, List<Object> sqlParamList,
								 Report report) throws Exception;

	/**
	 *  根据视图数据源生产报表并返回路径
	 * @param report 报表
	 * @param data 视图数据
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public String generateDynamicReportByViewDataSource(Report report, Collection<Document> data,ParamsTable params,IUser user)throws Exception;
	/**
	 * 根据自定义数据源生成报表并返回路径
	 * @param report
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public String generateDynamicReportByCustomDataSource(Report report,ParamsTable params,IUser user)throws Exception;

	/**
	 * 根据表单数据生成报表并返回路径
	 * @param report
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public String generateDynamicReportByFormDataSource(Report report,ParamsTable params,IUser user, String docid)throws Exception;

	/**
	 * 根据表单数据生成pdf并返回路径
	 * @param report
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public String generatePdfByFormDataSource(Report report,ParamsTable params,IUser user, String docid)throws Exception;

	/**
	 * 	获取数据源视图列信息
	 */
	public List<QueryColumnInfo> getViewColumnsInfos(String viewId)throws Exception;

	/**
	 * 根据视图数据源导出excel返回下载路径
	 * @param report
	 * @param data
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public String generateExcelByViewDataSource(Report report, Collection<Document> data,ParamsTable params,IUser user)throws Exception;

	/**
	 * 根据视图数据源导出pdf返回下载路径
	 * @param report
	 * @param data
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public String generatePdfByViewDataSource(Report report, Collection<Document> data,ParamsTable params,IUser user)throws Exception;

	/**
	 * 根据存储过程数据源导出excel返回下载路径
	 * @param report
	 * @param user
	 * @param params
	 * @return
	 * @throws Exception
	 */
	public String generateExcelByProcedure(Report report, IUser user, ParamsTable params) throws Exception;
	/**
	 * 获取报表自定义数据源的列信息
	 * @param customDataIscript
	 * @param report
	 * @param applicationId
	 * @return
	 * @throws Exception
	 */
	public List<QueryColumnInfo> getCustomColumnsInfos(String customDataIscript,Report report,ParamsTable params,IUser user,String applicationId)throws Exception;

	/**
	 * 	获取表单列信息
	 */
	public List<QueryColumnInfo> getFormColumnsInfos(String formId)throws Exception;

	/**
	 * 根据执行存储过程数据源生成报表并返回路径
	 * @param report 报表
	 * @param user	用户
	 * @param params 参数
	 * @return
	 * @throws Exception
	 */
	public String generateDynamicReportByProcedure(Report report,IUser user,ParamsTable params)throws Exception;


}
