package cn.myapps.runtime.report.dao;


import java.util.List;

import cn.myapps.common.exception.CommonException;
import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.common.model.report.Report;




public interface RuntimeOpenQueryDao {

    public List<QueryColumnInfo> getQueryColumnInfos(String sql, String dbDriver, String dbUrl, String dbUser, String dbPass ) throws CommonException;

    public List<QueryColumnInfo> getProcedureColumnsInfos(String procedureScript, String dbDriver, String dbUrl, String dbUser, String dbPass)throws Exception;

    public void generateDynamicReportDataSource(Report report, String sql, String dbDriver, String dbUrl, String dbUser, String dbPass ) throws CommonException;

    //存储过程数据源
    public void generateDynamicReportDataSourceByProcedure(Report report,String procedureScript, String dbDriver, String dbUrl, String dbUser, String dbPass) throws Exception;
}