package cn.myapps.runtime.notice;

import java.text.SimpleDateFormat;
import java.util.Date;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.auth.IUser;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.workflow.notification.ejb.SendMode;
import cn.myapps.support.weixin.WeixinServiceProxy;

public class WeixinMode implements SendMode {

	/**
	 * 发生消息
	 * @param title 标题
	 * @param discription 描述
	 * @param touser 接收用户账号
	 * @param doc 文档对象
	 * @return
	 * @throws Exception
	 */
//	public boolean send(String title,String description,String touser,IDocument doc) throws Exception {
//		
//		final String  topic = title;
//		final String desc = description;
//		final String to =touser;
//		final IDocument document = doc;
//		
//		new Thread(new Runnable() {
//			public void run() {
//				try {
//					WeixinServiceProxy.send(topic, desc, to, document);
//				} catch (Exception e) {
//					e.printStackTrace();
//				} finally {
//                	try {
//						PersistenceUtils.closeSessionAndConnection();
//					} catch (Exception e) {
//						e.printStackTrace();
//					}
//                }
//			}
//		}).start();
//		
//		return true;
//	}
	/**
	 * 发生消息
	 * @param title 标题
	 * @param discription 描述
	 * @param touser 接收用户账号
	 * @param doc 文档对象
	 * @param webUser 当前用户
	 * @return
	 * @throws Exception
	 */
//	public boolean send(String title,String description,String flowTypeMessage,String touser,IDocument doc,IUser webUser) throws Exception {
//		
//		//标题
//		final String  topic = "["+title+"]" + description;
//		//作者
//		String auditUser = webUser.getName();
//		//时间
//		String time = getDateTimeStr(doc.getLastmodified());
//		//动作
//		String act = flowTypeMessage+"该流程";
//		
//		String tempDesc = auditUser + time + act;
//		
//		if("待办超期".equals(flowTypeMessage)){
//			tempDesc= "待办已超期，请您尽快处理";
//		}
//		
//		//拼接描述
//		final String desc = tempDesc;
//		
//		
//		final String to =touser;
//		final IDocument document = doc;
//		
//		new Thread(new Runnable() {
//			public void run() {
//				try {
//					WeixinServiceProxy.send(topic, desc, to, document);
//				} catch (Exception e) {
//					e.printStackTrace();
//				}  finally {
//                	try {
//						PersistenceUtils.closeSessionAndConnection();
//					} catch (Exception e) {
//						e.printStackTrace();
//					}
//                }
//			}
//		}).start();
//		
//		return true;
//	}

	
	private String getDateTimeStr(Date date) {
		
		try{
			   SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
			   return "于"+format.format(date);
			}catch(Exception e){
				return "";
			}
			
	}
	@Override
	public boolean send(String subject, int subjectType, String summary, IUser responsible, IDocument document,
			IUser webUser) {
		//标题
		final String  topic = "["+subject+"]" + summary;
		//作者
		String auditUser = webUser.getName();
		//时间
		String time = getDateTimeStr(document.getLastmodified());
		//动作
//		String act = flowTypeMessage+"该流程";
		
		String tempDesc = auditUser + time ;
		
//		if("待办超期".equals(flowTypeMessage)){
//			tempDesc= "待办已超期，请您尽快处理";
//		}
		
		//拼接描述
		final String desc = tempDesc;
		
		
		final String to = responsible.getLoginno();
		
		new Thread(new Runnable() {
			public void run() {
				try {
					WeixinServiceProxy.send(topic, desc, to, document);
				} catch (Exception e) {
					e.printStackTrace();
				}  finally {
                	try {
						PersistenceUtils.closeSessionAndConnection();
					} catch (Exception e) {
						e.printStackTrace();
					}
                }
			}
		}).start();
		
		return true;
	}

}
