package cn.myapps.runtime.notice;

import cn.myapps.common.model.AuthtimeValueObject;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * 消息推送
 * @author Happy
 *
 */
public class Notification extends AuthtimeValueObject {
	
	private static final long serialVersionUID = -1490251964289404192L;
	
	/**
	 * 消息类型-常规消息
	 */
	public static final int TYPE_MESSAGE = 0;
	/**
	 * 消息类型-通知消息
	 */
	public static final int TYPE_ANNOUNCEMENT = 1;
	/**
	 * 消息类型-评论
	 */
	public static final int TYPE_COMMENT = 2;
	/**
	 * 消息类型-工作事项提醒消息
	 */
	public static final int TYPE_NOTICE = 3;
	
	/**
	 * 消息模块
	 */
	public static final String MODULE_WORK_FLOW = "workFlow";
	public static final String MODULE_MESSAGE = "message";
	public static final String MODULE_PM = "pm";
	public static final String MODULE_KM = "km";
	public static final String MODULE_QM = "qm";
	
	/**
	 * 被推送消息Id
	 */
	private String messageId;
	/**
	 * 发送者名称
	 */
	private String sender ;
	/**
	 * 发送者id
	 */
	private String senderId ;
	/**
	 * 接收者id
	 */
	private String receiverId;
	/**
	 * 模块
	 */
	private String module;
	/**
	 * 类型
	 */
	private int messageType;
	/**
	 * 摘要
	 */
	private String summary;
	/**
	 * 工作事项链接参数（JSON格式）
	 */
	private String linkParams;
	
	
	/**
	 * 创建时间
	 */
	private Date createTime; 
	

	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public String getLinkParams() {
		return linkParams;
	}

	public void setLinkParams(String linkParams) {
		this.linkParams = linkParams;
	}

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}
	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String senderId) {
		this.senderId = senderId;
	}

	public String getReceiverId() {
		return receiverId;
	}

	public void setReceiverId(String receiverId) {
		this.receiverId = receiverId;
	}

	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}

	public int getMessageType() {
		return messageType;
	}

	public void setMessageType(int messageType) {
		this.messageType = messageType;
	}

	
}
