package cn.myapps.runtime.notice;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import cn.myapps.common.model.AuthtimeValueObject;

/**
 * 工作事项通知、提醒
 * @author Happy
 *
 */
public class Notice extends AuthtimeValueObject{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4836070850643712525L;

	/**
	 * 通知摘要
	 */
	private String summary;
	
	/**
	 * 通知内容（JSON格式）
	 */
	private String content;
	
	/**
	 * @return the content
	 */
	public String getContent() {
		return content;
	}

	/**
	 * @param content the content to set
	 */
	public void setContent(String content) {
		this.content = content;
	}

	/**
	 * 接收用户id
	 */
	private String toUserId;
	
	/**
	 * 创建时间
	 */
	private Date createTime; 
	
	/**
	 * 是否已读
	 */
	private boolean read;
	
	/**
	 * 通知来源（功能模块）
	 */
	private String module;

	/**
	 * 工作事项链接参数（JSON格式）
	 */
	private String linkParams;
	
	/**
	 * 类型
	 */
	private int subjectType;

	protected String domainid;
	
	public int getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(int subjectType) {
		this.subjectType = subjectType;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}


	public String getToUserId() {
		return toUserId;
	}

	public void setToUserId(String toUserId) {
		this.toUserId = toUserId;
	}

	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}


	public boolean isRead() {
		return read;
	}

	public void setRead(boolean read) {
		this.read = read;
	}

	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}

	public String getLinkParams() {
		return linkParams;
	}

	public void setLinkParams(String linkParams) {
		this.linkParams = linkParams;
	}
	
	
}
