package cn.myapps.runtime.notice;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.workflow.notification.ejb.SendMode;
import cn.myapps.util.mail.EmailSender;

public class EmailMode implements SendMode {

//	private static final long EXPIRE_TIME = 24 * 60 * 60 * 1000;
//
//	String from;
//	String host;
//	String user;
//	String password;
//	String bcc;

//	private IUser webUser;

//	public EmailMode() {
//		from = PropertyUtil.get("from");
//		host = PropertyUtil.get("host");
//		user = PropertyUtil.get("user");
//		password = PropertyUtil.get("password");
//		bcc = PropertyUtil.get("bcc");
//	}

//	@Override
//	public boolean send(String subject, String content, IUser receiver, boolean mass)
//			throws Exception {
//		if (!StringUtil.isBlank(receiver.getEmail())) { // 接收人地址
//			String replyContent = null;
//			String body = content;
//			if (!StringUtil.isBlank(replyContent)) {
//				body += replyContent;
//			}
//			body = this.htmlDecodeEncoder(body);
//
//			EmailSender sender = EmailSender.getInstance();
//			
//			DomainVO domain = (DomainVO)AuthTimeServiceManager.domainRuntimeService().doView(webUser.getDomainid());
//			
//			from = domain.getSendAddress();
//			host = domain.getSendHost();
//			user = domain.getSendAccount();
//			password = domain.getSendPassword();
//			bcc = domain.getCcAddress();
//			sender.addEmail(from, receiver.getEmail(), subject, body, host, user, password, bcc, true,webUser);
//			sender.sendEmail();
//			return true;
//		}
//
//		return false;
//	}

//	public boolean send(String subject, String content, String receiver)
//			throws Exception {
//		return send(null, subject, content, receiver);
//	}

//	public boolean send(String subject, String content, String receiver,
//			Map<String, String> defineReply, boolean mass) throws Exception {
//		return send(null, subject, content, receiver, defineReply, mass);
//	}

//	public boolean send(String subject, String content, String receiver,
//			String replyPrompt, String code, boolean mass) throws Exception {
//		return send(null, subject, content, receiver, replyPrompt, code, mass);
//	}

//	public boolean send(String subject, String content, String receiver,
//			boolean mass) throws Exception {
//		return send(subject, content, receiver, null, mass);
//	}

//	public boolean send(String docid, String subject, String content,
//			IUser responsible) throws Exception {
//		return send(null, subject, content, responsible.getEmail());
//	}

//	public boolean send(String docid, String subject, String content,
//			String receiver) throws Exception {
//		return send(subject, content, receiver, false);
//	}
//
//	public boolean send(String docid, String subject, String content,
//			String receiver, String replyPrompt, String code, boolean mass)
//			throws Exception {
//		Map<String, String> params = new HashMap<String, String>();
//		params.put(replyPrompt, code);
//		return send(docid, subject, content, receiver, params, mass);
//
//	}

//	public boolean send(String docid, String subject, String content,
//			String receiver, Map<String, String> defineReply, boolean mass)
//			throws Exception {
//		if (!StringUtil.isBlank(receiver)) { // 接收人地址
//			String replyContent = null;
//			String body = content;
//			if (!StringUtil.isBlank(replyContent)) {
//				body += replyContent;
//			}
//			body = this.htmlDecodeEncoder(body);
//
//			EmailSender sender = EmailSender.getInstance();
//			
//			DomainVO domain = (DomainVO)AuthTimeServiceManager.domainRuntimeService().doView(webUser.getDomainid());
//			
//			from = domain.getSendAddress();
//			host = domain.getSendHost();
//			user = domain.getSendAccount();
//			password = domain.getSendPassword();
//			bcc = domain.getCcAddress();
//			sender.addEmail(from, receiver, subject, body, host, user, password, bcc, true,webUser);
//			sender.sendEmail();
//			return true;
//		}
//
//		return false;
//	}
	
	private String htmlDecodeEncoder(String content) {
		if (StringUtil.isBlank(content)) {
			return content;
		}
		content = content.replaceAll("&quot;", "\"");
		content = content.replaceAll("&amp;", "&");
		content = content.replaceAll("&lt;", "<");
		content = content.replaceAll("&gt;", ">");
		return content;
	}

	@Override
	public boolean send(String subject, int subjectType, String summary, IUser responsible, IDocument document,
			IUser webUser) {
		if (!StringUtil.isBlank(responsible.getEmail())) { // 接收人地址
			String replyContent = null;
			String body = summary;
			if (!StringUtil.isBlank(replyContent)) {
				body += replyContent;
			}
			body = this.htmlDecodeEncoder(body);

			EmailSender sender = EmailSender.getInstance();
			
			try {
				DomainVO domain = (DomainVO)AuthTimeServiceManager.domainRuntimeService().doView(webUser.getDomainid());
				
				String from = domain.getSendAddress();
				String host = domain.getSendHost();
				String user = domain.getSendAccount();
				String password = domain.getSendPassword();
				String bcc = domain.getCcAddress();
				sender.addEmail(from, responsible.getEmail(), subject, body, host, user, password, bcc, true,webUser);
				sender.sendEmail();
				return true;

			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return false;
	}

//	public boolean send(SummaryCfgVO summaryCfg, IDocument doc, IUser responsible)
//			throws Exception {
//		return send(summaryCfg.getTitle(), summaryCfg, doc, responsible);
//	}
//
//	public boolean send(String subject, SummaryCfgVO summaryCfg, IDocument doc,
//			IUser responsible) throws Exception {
//		String handleUrl = getHandleUrl(doc,responsible);
//		subject = subject + "[" + responsible.getName() + "]";
//
//		String content = "";
//		if (doc != null) {
//			content = summaryCfg.toSummay(doc,responsible);
//			content += "</br><hr>" + "<a href='" + handleUrl + "'" +">" + "马上处理" + "</a>";
//			return send(doc.getId(), subject, content, responsible.getEmail());
//		} else {
//			throw new OBPMValidateException("Could not send with null document");
//		}
//	}

//	private String getHandleUrl(IDocument doc,IUser responsible) {
//		if(!(doc instanceof Document)) return "";
//		
////		HttpServletRequest request = ServletActionContext.getRequest();
//		String token = Security.getEmailToken(responsible.getId(),new Date(System.currentTimeMillis() + EXPIRE_TIME));
//		Environment evt = Environment.getInstance();
//		StringBuffer handleUrl = new StringBuffer();
//		
////		handleUrl.append(request.getScheme());
////		handleUrl.append("://");
////		handleUrl.append(request.getServerName());
////		handleUrl.append(":").append(request.getServerPort());
//		handleUrl.append(evt.getBaseUrl());
//		handleUrl.append(evt.getContextPath());
//		handleUrl.append("/obpm/portal/good/html/form.html?");
//		handleUrl.append("appId=").append(doc.getApplicationid());
//		handleUrl.append("&docid=").append(doc.getId());
//		handleUrl.append("&formId=").append(((Document)doc).getFormid());
//		handleUrl.append("&opentarget=email");
//		handleUrl.append("&accessToken=").append(token);
//		
//		return handleUrl.toString();
//	}

//	public boolean send(String docid, String subject, String content,
//			String receiver, boolean isNeedReply, boolean mass)
//			throws Exception {
//		throw new UnsupportedOperationException();
//	}

//	public boolean send(String subject, SummaryCfgVO summaryCfg, IDocument doc,
//			IUser responsible, boolean approval) throws Exception {
//		return false;
//	}
}
