package cn.myapps.runtime.mobile.notice.controller;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.NoticeApi;
import cn.myapps.runtime.mobile.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;

@Controller(value="NoticeController")
@RequestMapping(value="/runtime/app/notice")
@Scope("prototype")
@Api(tags = "事件通知模块")
public class NoticeController extends BaseController {
	
	/**
	 * 获取通知
	 */
	@RequestMapping(value="/list.action")
	@ResponseBody
	@ApiOperation(value = "获取通知", notes = "获取通知")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "access_token",value = "access_token",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doList(){
		if (getUserId() == null) {
			return addActionResult(false, "access_token invalid", null);
		}
	   try {
		    ParamsTable params = getParams();

		    FeignConfig.ACCESS_TOKEN = Security.getToken(getUserId());
		    NoticeApi noticeApi = SpringApplicationContextUtil.getBean(NoticeApi.class);
		    int pageNum = params.getParameterAsInteger("pageNum")==null?1:params.getParameterAsInteger("pageNum");
		    int pageSize = params.getParameterAsInteger("pageSize")==null?Integer.MAX_VALUE:params.getParameterAsInteger("pageSize");
		    JSONArray datas = JSONObject.fromObject(noticeApi.getNotices("0", pageNum, pageSize)).getJSONObject("data").getJSONArray("datas");
		    List<Map<String, Object>> result = new ArrayList<Map<String,Object>>();
		    for (Iterator<JSONObject> iterator = datas.iterator(); iterator.hasNext(); ) {
				JSONObject notice = iterator.next();
		    	Map<String, Object> map = new HashMap<String, Object>();
		    	map.put("id", notice.get("id"));
				String content = notice.getString("content");
		    	if (StringUtil.isBlank(content)) {
		    		map.put("content", new JSONObject());
				}else{
					map.put("content", JSONObject.fromObject(content));
				}
		    	String linkParams = notice.getString("linkParams");
		    	if (StringUtil.isBlank(linkParams)) {
		    		map.put("linkParams", new JSONObject());
				}else{
					map.put("linkParams", JSONObject.fromObject(linkParams));
				}
		    	map.put("toUserId", notice.get("toUserId"));
		    	map.put("createTime", notice.get("createTime"));
		    	map.put("read", false);
		    	map.put("module", notice.get("module"));
		    	map.put("subjectType", notice.get("subjectType"));
		    	map.put("messageType", 1);
		    	result.add(map);
			}
		    return addActionResult(true, "ok", result);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
     * 删除通知
     */
	@RequestMapping(value="/delete.action")
	@ResponseBody
	@ApiOperation(value = "删除通知", notes = "删除通知")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id",value = "用户id",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doDelete(){
		 try {
		 		FeignConfig.ACCESS_TOKEN = Security.getToken(getUserId());
		 		NoticeApi noticeApi = SpringApplicationContextUtil.getBean(NoticeApi.class);
			    ParamsTable params = getParams();
			    String id = params.getParameterAsString("id");
			 	noticeApi.removeNotice(id);
			    return addActionResult(true, "ok", null);
			} catch (Exception e) {
				return addActionResult(false, e.getMessage(), null);
			}
	}
	
	 /**
     * 标记已读
     */
	@RequestMapping(value="/read.action")
	@ResponseBody
	@ApiOperation(value = "标记已读", notes = "标记已读")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "access_token",value = "access_token",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "ids",value = "联系人主键",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doRead(){
		try {
		    ParamsTable params = getParams();
		    String ids = params.getParameterAsString("ids");
		   	FeignConfig.ACCESS_TOKEN = Security.getToken(getUserId());
			NoticeApi noticeApi = SpringApplicationContextUtil.getBean(NoticeApi.class);
			noticeApi.readNotice(ids);
		    return addActionResult(true, "ok", null);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}
}
