package cn.myapps.runtime.mobile.domain.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.sysconfig.service.SysConfigProcess;
import cn.myapps.authtime.sysconfig.service.SysConfigProcessBean;
import cn.myapps.common.model.sysconfig.HxImConfig;
import cn.myapps.runtime.mobile.common.controller.BaseController;

@Controller(value="DomainController")
@RequestMapping(value="/runtime/app")
@Scope("prototype")
public class DomainController extends BaseController{
	
	/**
	 * 获取企业域列表
	 * @throws Exception 
	 */
	@RequestMapping(value="/domains/list.action")
	@ResponseBody
	public Map<String, Object> doList() throws Exception{
		Collection<DomainVO> domains = new ArrayList<DomainVO>();
		DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
		domains = dp.getDomainByStatus(1);
		List<Map<String, String>> result = new ArrayList<Map<String,String>>();
		for (Iterator<DomainVO> iterator = domains.iterator(); iterator.hasNext(); ) {
			DomainVO domain = iterator.next();
			Map<String, String> map = new HashMap<String, String>();
			map.put("id", domain.getId());
			map.put("name", domain.getName());
			result.add(map);
		}
		Map<String, Object> json = addActionResult(true, "ok", result);
		return json;
	}
	
	/**
	 * 获取环信配置信息
	 * @throws Exception 
	 */
	@RequestMapping(value="/hx/config.action")
	@ResponseBody
	public Map<String, Object> doConfig() throws Exception{
		SysConfigProcess sysConfigProcess = new SysConfigProcessBean();
		HxImConfig result = sysConfigProcess.getHxImConfig();
		Map<String, Object> json = addActionResult(true, "ok", result);
		return json;
	}
}
