package cn.myapps.runtime.mobile.common.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.constans.Web;

@RestController
public class BaseController {
	private static final Logger logger = LoggerFactory.getLogger(BaseController.class);
	
	@Autowired  
	protected HttpServletRequest request;
	
	/**
	 * 
	 */
	protected static final long ACCESS_TOKEN_EXPIRES = 30*24*60*60*1000L;
	
	protected static final String ACTION_RESULT_KEY = "status";
	protected static final int ACTION_RESULT_VALUE_SUCCESS = 0;
	protected static final int ACTION_RESULT_VALUE_FAULT = 1;
	
	protected static final String ACTION_MESSAGE_KEY = "message";
	protected static final String ACTION_DATA_KEY = "data";
	
	
	
	
	//将会被Struts2序列化为JSON字符串的对象,用来作为控制层返回结果的容器
	protected Map<String, Object> dataMap = new HashMap<String, Object>();

	protected String[] _selects = null;
	
	protected String access_token  = null;
	
	protected ParamsTable params;
	
	protected DataPackage<?> datas = null;
	
	protected Collection<?> list = null;
	
	public String[] get_selects() {
		return _selects;
	}
	public void set_selects(String[] selects) {
		_selects = selects;
	}
	public ParamsTable getParams() {
		if (params == null) {
			params = ParamsTable.convertHTTP(request);

			if (params.getParameter("_pagelines") == null){
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}

		return params;
	}
	public ParamsTable getParams(HttpServletRequest request) {
		if (params == null) {
			params = ParamsTable.convertHTTP(request);
			String sessionId = "";//FIXME 需从参数传递web上下文
			params.setSessionid(sessionId);

			if (params.getParameter("_pagelines") == null){
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}

		return params;
	}
	public DataPackage<?> getDatas() {
		return datas;
	}
	public void setDatas(DataPackage<?> datas) {
		this.datas = datas;
	}
	
	/**
	 * @return the access_token
	 */
	public String getAccess_token() {
		return access_token;
	}
	/**
	 * @param access_token the access_token to set
	 */
	public void setAccess_token(String access_token) {
		this.access_token = access_token;
	}
	
	public WebUser getUser() {
		WebUser webUser = null;
		try {
			webUser = AuthTimeServiceManager.getWebUser(request);
		} catch (Exception ex) {
			logger.error("获取当前请求用户发生异常:{}", Security.getTokenFromRequest(request), ex);
		}

		return webUser;
	}

	public String getUserId() {
		return Security.getUserIdFromToken(request);
	}
	
	 /**
     * Struts2序列化指定属性时，必须有该属性的getter方法
     * @return
     */
    public Map<String, Object> getDataMap() {
        return dataMap;
    }
    
	public Collection<?> getList() {
		return list;
	}
	public void setList(Collection<?> list) {
		this.list = list;
	}
	/**
     * 添加Action处理结果
     * @param isSuccess
     * 		是否成功处理
     * @param message
     * 		返回消息
     * @param data
     * 		返回数据
     */
    public Map<String, Object> addActionResult(boolean isSuccess,String message,Object data){
    	dataMap.put(ACTION_RESULT_KEY, isSuccess?ACTION_RESULT_VALUE_SUCCESS : ACTION_RESULT_VALUE_FAULT );
    	dataMap.put(ACTION_MESSAGE_KEY, message);
    	if(data != null){
    		dataMap.put(ACTION_DATA_KEY, data);
    	}
    	return dataMap;
    }
}
