package cn.myapps.runtime.mobile.application.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.model.application.Application;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.runtime.mobile.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;

@Controller(value="ApplicationController")
@RequestMapping(path="/runtime/app/applications")
@Api(tags = "工作台模块")
public class ApplicationController extends BaseController{
	/**
	 * 获取软件列表
	 */
	@RequestMapping("/list.action")
	@ResponseBody
	@ApiOperation(value = " 获取应用列表", notes = " 获取应用列表")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "access_token",value = "access_token",required = true,paramType = "query",dataType = "string"),
	})
	public Map<String, Object> doList(){
		if (getUserId() == null) {
			return addActionResult(false, "access_token invalid", null);
		}
		String userId = getUserId();
		Map<String, Object> json = null;
		try {
			List<Map<String, Object>> result = new ArrayList<Map<String,Object>>();
			ApplicationDesignTimeService process = DesignTimeServiceManager.applicationDesignTimeService();
			List<Application> app = process.getListByWebUser(getUser());

			//考勤打卡应用是否已授权，默认所有人都授权
			boolean appExist = app.stream().anyMatch(ix -> ix.getId().equals(Application.KAOQINDAKA_APP_CODE));
			if(!appExist){
				Application dakaApp = process.findById(Application.KAOQINDAKA_APP_CODE);
				if(dakaApp != null){
					app.add(dakaApp);
				}
			}
			
			/*
			String domainId = getUser().getDomainid();
			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainId);
			if(domain.isEnable(Application.KM_APPLICATION_ID)){
	        	String km_uri = "/../kms/kmsphone/index.html?application=km&mode=app&jump=homepage&access_token=&userId=" + userId;
	            Map<String, Object> map5 = new HashMap<String, Object>();
	            map5.put("id", "km");
	            map5.put("name", "知识文档库");
	            map5.put("description", "企业文档，随时随地，想查就查;提供多种渠道，有条不紊的存储知识,提供知识分享和传播渠道，方便查找知识，员工能够更好的掌握业务知识，为企业服务建立安全的企业知识库，避免了知识泄漏能很好的为企业知识管理服务,提升企业的竞争力");
	            map5.put("logourl", "/uploads/app/km.png");
	            Map<String, Object> jumpToUrl5 = new HashMap<String, Object>();
	            Map<String, Object> km_url = new HashMap<String, Object>();
	            km_url.put("url", km_uri);
	            km_url.put("name", "进入系统");
	            jumpToUrl5.put("url1", km_url);
	            map5.put("jumpToUrl", jumpToUrl5);
	            result.add(map5);
			}
			 */
			
			for (Iterator<Application> iterator = app.iterator(); iterator.hasNext();) {
				Application appVO = iterator.next();
				Map<String, Object> map = new HashMap<String, Object>();
				map.put("id", appVO.getId());
				map.put("name", appVO.getName());
				map.put("description", appVO.getDescription());
				map.put("logourl", "/uploads/app/oa.png" );
				Map<String, Object> jumpToUrl = new HashMap<String, Object>();
				Map<String, Object> url = new HashMap<String, Object>();
				String toUrl =  "/mobile/index.html?application=" + appVO.getId() + "&mode=app&jump=homepage&access_token=&userId=" + userId;
				url.put("url", toUrl);
				url.put("name", "进入系统");
				jumpToUrl.put("url1", url);
                map.put("jumpToUrl", jumpToUrl);
				result.add(map);
			}
			json = addActionResult(true, "ok", result);
		}catch (Exception e) {
			addActionResult(false, e.getMessage(), null);
			e.printStackTrace();
		}
		return json;
	}
}
