package cn.myapps.runtime.menu.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.document.ejb.Document;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceUtil {

	public boolean isLinkToView(String resourceid) throws Exception{
		ResourceDesignTimeService rosourceprocess = DesignTimeServiceManager.resourceDesignTimeService();
		ResourceVO resource =(ResourceVO) rosourceprocess.doView(resourceid);
		if(resource!=null){
			if(resource.getLinkType()!=null && resource.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())){
				return true;
			}
		}
		return false;
	}


	public String getTotalRowByResourceid(String resourceid,HttpServletRequest request){
		if(resourceid.length()<=0){
			return "0";
		}
		StringBuffer html =new StringBuffer();
		try {

			ViewDesignTimeService viewprocess = DesignTimeServiceManager.viewDesignTimeService();
			ResourceDesignTimeService resourceprocess = DesignTimeServiceManager.resourceDesignTimeService();
			ResourceVO resource = resourceprocess.doView(resourceid);
			if(resource==null){
				return "0";
			}
			WebUser user = AuthTimeServiceManager.getWebUser(request);

			if(resource.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())){
				if(resource.getActionContent()==null || resource.getActionContent().equals("")){
					return "0";
				}
				AbstractView view = (AbstractView) viewprocess.doView((String)resource.getActionContent());
				if (view != null) {
					DataPackage<Document> datas = view.getViewTypeImpl().getViewDatas(new ParamsTable(), user, new Document());
					html.append(String.valueOf(datas.rowCount));
					return html.toString();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "0";
	}

	/**
	 * 根据菜单的集合生成菜单并以树(Tree)形式的集合.
	 *
	 * @param cols
	 *            菜单的集合
	 * @param startNode
	 *            菜单的开始节点
	 * @param excludeNodeId
	 *            不包括的节点
	 * @param deep
	 *            深入级别
	 * @return 树(Tree)形式的菜单集合
	 * @throws Exception
	 */
	public static Map<String, String> deepSearchMenuTree(Collection<ResourceVO> cols,
														 ResourceVO startNode, String excludeNodeId, int deep)
			throws Exception {
		Map<String, String> list = new LinkedHashMap<String, String>();

		String prefix = "|------------------------------------------------";

		Iterator<ResourceVO> iter = cols.iterator();

		//为空时,查询主菜单
		if(startNode == null) {
			list.put("", "{*[cn.myapps.core.resource.none]*}");
			while (iter.hasNext()) {
				ResourceVO vo = iter.next();

				if(vo.getId().equals(excludeNodeId)){
					continue;
				}

				if(vo.getParent() instanceof Application){
					if(!vo.getId().equals(excludeNodeId)){
						list.put(vo.getId(),prefix.substring(0,deep*2)+vo.getName());
					}
					//查询主菜单下的子菜单
					Map<String,String> tmp = deepSearchMenuTree(cols,vo,excludeNodeId,deep+2);
					list.putAll(tmp);
				}

			}
		}

		//查询子菜单的子菜单
		if(startNode != null) {
			iter = cols.iterator();
			while(iter.hasNext()) {
				ResourceVO vo = iter.next();

				if(vo.getId().equals(excludeNodeId)){
					continue;
				}

				if(startNode.getId().equals(vo.getSuperior())) {
					list.put(vo.getId(),prefix.substring(0,deep*2)+vo.getName());
					Map<String,String> tmp = deepSearchMenuTree(cols,vo,excludeNodeId,deep+2);
					list.putAll(tmp);
				}
			}
		}

		return list;
	}
}