package cn.myapps.runtime.login.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.sysconfig.AuthConfig;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.constans.Web;
import cn.myapps.runtime.workflow.notification.ejb.SendMode;
import cn.myapps.support.sms.SMSMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.util.http.CookieUtil;

public class LoginHelper {

	private static final Logger log = LoggerFactory.getLogger(LoginHelper.class);

	/**
	 * 获取所有企业域名
	 * @return 所有企业域名称列表
	 */
	public Collection<String> getDomainNameList(){
		Collection<String> map = new ArrayList<String>();
		try {
			DomainProcess process = AuthTimeServiceManager.domainRuntimeService();;
			Collection<DomainVO> col = process.getDomainByStatus(1);
			Iterator<DomainVO> it = col.iterator();
			while(it.hasNext()){
				DomainVO vo = it.next();
				map.add(vo.getName());
			}
			return map;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return map;
	}

	/**
	 * 获取发起请求的客户端IP
	 *
	 * @param request
	 * @return
	 */
	public static String getRequestIp(HttpServletRequest request) {
		String ip = null;
		ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		return ip;
	}

	/**
	 * 发送手机验证码短信
	 * @param user
	 * @param request
	 * @return
	 * 	超时时间
	 * @throws Exception
	 */
	public static int sendSMSCheckCode(UserVO user, HttpServletRequest request) throws Exception{
		int timeout = 0;
		try {

			PropertyUtil.reload("sso");
			timeout = Integer.parseInt(PropertyUtil.get(AuthConfig.SMS_TIMEOUT));
			String checkCode = getRandomCode(5);
			//String content = PropertyUtil.get(AuthConfig.SMS_CONTENT).replace("$", checkCode);
			String content = checkCode + "{验证码}";
			request.getSession().setAttribute(Web.SESSION_ATTRIBUTE_SMSCHECKCODE, checkCode);
			SendMode sender = new SMSMode();

			sender.send("",0, content, user, null, user);

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
		return timeout;

	}

	public static String getRandomCode(int length){
		StringBuffer code = new StringBuffer();
		String[] cos = new String[]{"0","1","2","3","4","5","6","7","8","9"};
		for(int i=0;i<length;i++){
			code.append(cos[new Random().nextInt(9)]);
		}
		return code.toString();
	}
}
