package cn.myapps.runtime.log.aspect;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.logger.model.LogVO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceFactory;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.log.aspect.instruction.LogInstruction;
import cn.myapps.runtime.log.aspect.instruction.LogInstructionExecutor;
import cn.myapps.runtime.logger.service.LogHelper;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

@Aspect
@Component
public class LogsAspectImpl implements LogsAspect {

    @Autowired(required = false)
    protected HttpServletRequest request;

    protected WebUser getUser() throws Exception {
        WebUser user = null;
        Object frontUser = AuthTimeServiceManager.getWebUser(request);

        if (frontUser == null)
            user = getAnonymousUser();
        else
            user = (WebUser) frontUser;

        return user;
    }

    @After("execution(* cn.myapps.runtime.activity.controller.ActivityController.runBeforeActionScript(..))")
    @Override
    public void activityLogs(JoinPoint point) throws Exception {
        try {
            if(getUser().isRecordLog()){
                String description = "";
                String ip = LogHelper.getRequestIp(request);
                String type = request.getParameter("actType");
                String id = (String) point.getArgs()[0];
                ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
                Activity act = activityService.findById(id);
                if(act.getUri().contains(".view")){
                    ViewDesignTimeService viewProcess = DesignTimeServiceManager.viewDesignTimeService();
                    String viewId = request.getParameter("viewId");
                    AbstractView view = viewProcess.doView(viewId);
                    description = "视图-" + view.getName();
                }
                if(act.getUri().contains(".form")){
                    String formId = request.getParameter("formId");
                    FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
                    Form form = (Form) formService.doView(formId);
                    description = "表单-" + form.getName();
                }
                System.out.println("操作人："+getUser().getName()+"--类型:"+act.getName()+"--描述:"+description+"--ip:"+ip);
                LogVO logVo = LogVO.valueOf(getUser(), act.getName(), description, ip);
                LogInstructionExecutor.getInstance().put(new LogInstruction(logVo,getUser(),ip,LogInstruction.INSERT_RUNTIME_LOG));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Before("execution(* cn.myapps.authtime.*.controller.*.*(..))")
    @Override
    public void authtimeLogs(JoinPoint point) throws Exception {
        try {
            WebUser adminUser = AuthTimeServiceManager.getAdminUser(request);
            String ip = LogHelper.getRequestIp(request);
            LogInstructionExecutor.getInstance().put(new LogInstruction(point,adminUser,ip,LogInstruction.INSERT_AUTHTIME_LOG));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private WebUser getAnonymousUser() throws Exception {
        UserVO vo = new UserVO();

        vo.getId();
        vo.setName("GUEST");
        vo.setLoginno("guest");
        vo.setLoginpwd("");
        vo.setRoles(null);
        vo.setEmail("");

        return new WebUser(vo);
    }
}
