package cn.myapps.runtime.helper;

import java.util.Collection;

import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.style.repository.service.StyleRepositoryDesignTimeService;

public class StyleRepositoryHelper {
	
	private StyleRepositoryDesignTimeService process;
	
	public StyleRepositoryHelper() throws Exception {
		super();
		this.process = DesignTimeServiceManager.styleRepositoryDesignTimeService();
	}


	/**
	 * 根据应用标识,返回相应样式库(StyleRepository)集合
	 * 
	 * @param application
	 *            应用标识
	 * @return 样式库(StyleRepository)集合
	 * @throws Exception
	 */
	public Collection<StyleRepositoryVO> get_listStyleByApp(String application) throws Exception {
		return process.getStyleRepositoryByApplication(application);
	}

	/**
	 * 根据样式主键查找,返回样式库内容
	 * 
	 * @param styleid
	 *            样式主键
	 * @return 样式库内容
	 * @throws Exception
	 */
	public static String getStyleContent(String styleid) throws Exception {
		StyleRepositoryDesignTimeService sp = DesignTimeServiceManager.styleRepositoryDesignTimeService();
		StyleRepositoryVO sv = (StyleRepositoryVO) sp.doView(styleid);
		if (sv != null)
			return sv.getContent();
		else
			return null;
	}

}
