package cn.myapps.runtime.flowcenter.service;

import cn.myapps.authtime.user.model.UserDefined;
import cn.myapps.authtime.user.service.UserDefinedProcess;
import cn.myapps.common.ModelSuffix;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.permission.Permission;
import cn.myapps.common.model.resource.ResourceType;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.resource.StartMenuNode;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeService;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.WorkVO;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.work.ejb.WorkProcess;
import cn.myapps.runtime.dynaform.work.ejb.WorkProcessBean;
import cn.myapps.util.ProcessFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.net.URLEncoder;
import java.util.*;

public class FlowCenterRunTimeServiceImpl implements FlowCenterRumTimeService {

    @SuppressWarnings("unchecked")
    @Override
    public List<StartMenuNode> getStartMenus(String applicationId, boolean isMobile, boolean isUsual, boolean isUsualList,
                                             IUser user) throws Exception {

        String[] roleids = user.getRolelist().replace("'","").split(",");
        List<StartMenuNode> arr = new ArrayList<StartMenuNode>();

        ResourceDesignTimeService process = DesignTimeServiceManager.resourceDesignTimeService();
        List<ResourceVO> resources = new ArrayList<ResourceVO>();
        if(isMobile){
            resources = process.list(applicationId, ModelSuffix.MOBILE_MENU_PATH_SUFFIX, ModelSuffix.MOBILE_MENU_FILE_SUFFIX, null);
        } else {
            resources = process.list(applicationId, ModelSuffix.MENU_PATH_SUFFIX, ModelSuffix.MENU_FILE_SUFFIX, null);
        }

        Map<String, List<ResourceVO>> treeMap = new HashMap<String, List<ResourceVO>>();

        for (ResourceVO resourceVO : resources) {
            String parentId = resourceVO.getParentId();
            List<ResourceVO> list = null;
            if (treeMap.containsKey(parentId)) {
                list = treeMap.get(parentId);
            } else {
                list = new ArrayList<ResourceVO>();
            }
            list.add(resourceVO);
            treeMap.put(parentId, list);
        }

        UserDefinedProcess userDefinedProcess = (UserDefinedProcess) ProcessFactory
                .createProcess(UserDefinedProcess.class);
        UserDefined userDefined = userDefinedProcess.doFindMyCustomUserDefined(user);
        //常用菜单id集合
        List<String> usualStartMenuIds = new ArrayList<String>();
        //常用菜单点击次数
        JSONObject countJson = new JSONObject();
        if(userDefined != null){
            String usualStartMenus = userDefined.getUsualStartMenus();
            if (!StringUtil.isBlank(usualStartMenus)) {
                JSONArray list = cn.myapps.util.json.JsonTmpUtil.fromObject(usualStartMenus);
                for (@SuppressWarnings("rawtypes")
                     Iterator iterator = list.iterator(); iterator.hasNext();) {
                    JSONObject json = (JSONObject) iterator.next();
                    String menuId = (String) json.get("menuId");
                    String count = (String) json.get("count");
                    countJson.put(menuId, count);
                    usualStartMenuIds.add(menuId);
                }
            }
        }

        for (ResourceVO resourceVO : resources) {
            if (resourceVO.getShowType() == ResourceVO.SHOW_TYPE_MENU) { // 菜单类型
                continue;
            }
            if(ResourceVO.SHOW_TYPE_BOTH == resourceVO.getStatus()){
                //状态失效
                continue;
            }

            if (resourceVO.getType() != null && !isMobile && resourceVO.getType().equals(ResourceType.RESOURCE_TYPE_MOBILE)) { // 手机类型
                continue;
            }
            if (!ResourceVO.LinkType.FORM.getCode().equals(
                    resourceVO.getLinkType())) {
                if(!isUsual && !isUsualList){
                    String id = resourceVO.getId();
                    List<ResourceVO> list = new ArrayList<ResourceVO>();
                    list = getAllChildrenResource(id, treeMap, list);
                    // 拿到菜单下的各发起的表单，或者视图
                    if (list != null) {
                        List<ResourceVO> listTemp = new ArrayList<ResourceVO>();
                        listTemp.addAll(list);
                        for (ResourceVO resourceVO2 : listTemp) {
                            // 如果资源为视图类型，或者linkType为空，或者是报表类型,或者自定义链接外部,或者自定义链接内部,或者是菜单类型则去掉
                            if (StringUtil.isBlank(resourceVO2.getLinkType())
                                    || !resourceVO2.getLinkType().equals(
                                    ResourceVO.LinkType.FORM.getCode())
                                    || resourceVO2.getShowType() == ResourceVO.SHOW_TYPE_MENU) {
                                if(isMobile){
                                    if(!resourceVO2.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())){
                                        list.remove(resourceVO2);
                                    }
                                } else {
                                    list.remove(resourceVO2);
                                }
                            } else {
                                if(ResourceVO.PERMISSION_TYPE_PRIVATE.equals(resourceVO2.getPermissionType())){
                                    boolean isAllow = PermissionUtil.check(roleids, resourceVO2.getId(), resourceVO2.getId(), Permission.MENU_INVISIBLE);
                                    if (!isAllow) {// 判断权限问题
                                        list.remove(resourceVO2);
                                    }
                                }
                            }
                        }
                    }
                    if (list == null || list.isEmpty()) {
                        continue;
                    }
                }
            }

            if(ResourceVO.PERMISSION_TYPE_PRIVATE.equals(resourceVO.getPermissionType())){
                boolean isAllow = PermissionUtil.check(roleids, resourceVO.getId(), resourceVO.getId(), Permission.MENU_INVISIBLE);
                if (!isAllow) { // 权限
                    continue;
                }
            }


            // 多语言标签
            if (!StringUtil.isBlank(resourceVO.getMultiLanguageLabel())) {
                String multiLangTag = resourceVO.getName();
                String multiLanguageLabel = resourceVO.getMultiLanguageLabel();
                // 因为在Filter里中文会因为乱码问题导致解析错误，暂未找到解决方案，因此urlencode将中文进行编码
                String labelHex = URLEncoder.encode(multiLanguageLabel);
                String nameHex = URLEncoder.encode(multiLangTag);
                multiLangTag = "{*[" + labelHex + "^" + nameHex + "^true]*}";
                resourceVO.setDescription(multiLangTag);
            }
            StartMenuNode startMenuNode = resourceAdapter(resourceVO);

            boolean isExist = false;
            if (!usualStartMenuIds.isEmpty()) {
                String count = (String) countJson.get(startMenuNode.getId());
                if(!StringUtil.isBlank(count)){
                    startMenuNode.setOrderNo(count);
                    isExist = true;
                    startMenuNode.setUsual(isExist);
                }
            } else {
                if(resourceVO.getIsUsual().equals("true")){
                    isExist = true;
                }
            }
            if (isUsual) {
                if(!StringUtil.isBlank(resourceVO.getShowtotalrow()) && Boolean.valueOf(resourceVO.getShowtotalrow())){
                    startMenuNode.setTotalRow(getTotalRowByResource(resourceVO, new ParamsTable(), user));
                }
                if (!isExist) continue;
            } else {
                startMenuNode.setUsual(isExist);
            }
            arr.add(startMenuNode);
        }

        if (isUsual) {
            MyCompartor2 mc = new MyCompartor2();
            Collections.sort(arr, mc);
        }

        return arr;
    }

    //根据菜单id获取所有孩子菜单
    private List<ResourceVO> getAllChildrenResource(String parentId,Map<String, List<ResourceVO>> treeMap,List<ResourceVO> resourceVOs) throws Exception{
        List<ResourceVO> resourceTemps = treeMap.get(parentId);
        if(resourceTemps!=null){
            for (ResourceVO resourceVO : resourceTemps) {
                getAllChildrenResource(resourceVO.getId(), treeMap, resourceVOs);
                resourceVOs.add(resourceVO);
            }
        }
        return resourceVOs;
    }

    /**
     * 菜单解析器
     *
     * @param resourceVO
     * @return
     */
    private StartMenuNode resourceAdapter(ResourceVO resourceVO) {
        StartMenuNode result = new StartMenuNode();
        String icoStr = resourceVO.getIco();
        JSONObject icoStrJson = new JSONObject();
        if (!StringUtil.isBlank(icoStr)) {
            icoStrJson = JSONObject.fromObject(icoStr);
        }
        result.setId(resourceVO.getId());
        if(ResourceVO.LinkType.VIEW.getCode().equals(resourceVO.getLinkType())){
            result.setViewId(resourceVO.getActionContent());
        } else {
            result.setFormId(resourceVO.getActionContent());
        }
        result.setParent(resourceVO.getParentId());
        result.setDescription(!StringUtil.isBlank(resourceVO.getDescription())?resourceVO.getDescription():resourceVO.getName());
        result.setIco(icoStrJson);
        result.setQueryString(resourceVO.getQueryString());
        return result;
    }

    @Override
    public List<Map<String, Object>> getPendingNavs(String applicationId,
                                                    IUser user) throws Exception {
        String domainId = user.getDomainid();
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        BillDefiDesignTimeService bp = DesignTimeServiceManager.billDefiDesignTimeService();
        Collection<Application> apps = appService.getListByWebUser(user);
        if (StringUtil.isBlank(applicationId)) {
            for (Application applicationVO : apps) {
                Map<String, Object> applicationVOInfo = new HashMap<String, Object>();
                RunTimeService<Document> process = new WorkProcessBean(applicationVO.getId()
                );
                Collection<Map<String, Object>> pendingFlowList = ((WorkProcess) process)
                        .getPendingFlowList(true, applicationVO.getId(), domainId,
                                user);
                if (pendingFlowList.size() <= 1) {
                    // 如果该软件没有数据则添加该软件的数据
                    // 大小为1的时候表明只有"全部"这一项
                    continue;
                }
                Collection<BillDefiVO> flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for(BillDefiVO bv : flows){
                    map.put(bv.getId(), bv.getBilldefiNo());
                }
                for (Map<String, Object> objectMap:pendingFlowList){
                    String order = map.get(objectMap.get("id"));
                    objectMap.put("order",order);
                }
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("pendingFlowList", pendingFlowList);
                result.add(applicationVOInfo);
            }
        } else {
            Application applicationVO = appService.findById(applicationId);
            if(applicationVO != null) {
                Collection<BillDefiVO> flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for(BillDefiVO bv : flows){
                    map.put(bv.getId(), bv.getBilldefiNo());
                }
                Map<String, Object> applicationVOInfo = new HashMap<String, Object>();
                RunTimeService<Document> process = new WorkProcessBean(applicationId);
                Collection<Map<String, Object>> pendingFlowList = ((WorkProcess) process)
                        .getPendingFlowList(true, applicationId, domainId,
                                user);
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                for (Map<String, Object> objectMap:pendingFlowList){
                    String order = map.get(objectMap.get("id"));
                    objectMap.put("order",order);
                }
                applicationVOInfo.put("pendingFlowList", pendingFlowList);
                result.add(applicationVOInfo);
            }
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getProcessedNavs(String applicationId,
                                                      IUser user) throws Exception {
        String domainId = user.getDomainid();
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        BillDefiDesignTimeService bp = DesignTimeServiceManager.billDefiDesignTimeService();
        Collection<Application> apps = appService.getListByWebUser(user);
        if (StringUtil.isBlank(applicationId)) {
            for (Application applicationVO : apps) {
                Map<String, Object> applicationVOInfo = new HashMap<String, Object>();
                RunTimeService<Document> process = new WorkProcessBean(
                        applicationVO.getId());
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess) process)
                        .getProcessedRunningFlowList(applicationVO.getId(),
                                domainId, user);
                if (processedFlowList.size() <= 1) {
                    // 如果该软件没有数据则添加该软件的数据
                    // 大小为1的时候表明只有"全部"这一项
                    continue;
                }
                Collection<BillDefiVO> flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for(BillDefiVO bv : flows){
                    map.put(bv.getId(), bv.getBilldefiNo());
                }
                for (Map<String, Object> objectMap:processedFlowList){
                    String order = map.get(objectMap.get("id"));
                    objectMap.put("order",order);
                }
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("processedFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        } else {
            for (Application applicationVO : apps) {
                Collection<BillDefiVO> flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for(BillDefiVO bv : flows){
                    map.put(bv.getId(), bv.getBilldefiNo());
                }
                Map<String, Object> applicationVOInfo = new HashMap<String, Object>();
                RunTimeService<Document> process = new WorkProcessBean(
                        applicationId);
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess) process)
                        .getProcessedRunningFlowList(applicationId,
                                domainId, user);
                if (processedFlowList.size() <= 1) {
                    // 如果该软件没有数据则添加该软件的数据
                    // 大小为1的时候表明只有"全部"这一项
                    continue;
                }
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                for (Map<String, Object> objectMap:processedFlowList){
                    String order = map.get(objectMap.get("id"));
                    objectMap.put("order",order);
                }
                applicationVOInfo.put("processedFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getCarboncopyNavs(String applicationId,
                                                       IUser user,boolean isRead) throws Exception {
        String domainId = user.getDomainid();
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        Collection<Application> apps = appService.getListByWebUser(user);
        if (StringUtil.isBlank(applicationId)) {
            for (Application applicationVO : apps) {
                Map<String, Object> applicationVOInfo = new HashMap<String, Object>();
                RunTimeService<Document> process = new WorkProcessBean(
                        applicationVO.getId());
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess) process)
                        .getCarboncopyRunningFlowList(applicationVO.getId(),
                                domainId, user,isRead);
                if (processedFlowList.size() <= 1) {
                    // 如果该软件没有数据则添加该软件的数据
                    // 大小为1的时候表明只有"全部"这一项
                    continue;
                }
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("carboncopyFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        } else {
            for (Application applicationVO : apps) {
                Map<String, Object> applicationVOInfo = new HashMap<String, Object>();
                RunTimeService<Document> process = new WorkProcessBean(
                        applicationId);
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess) process)
                        .getCarboncopyRunningFlowList(applicationId,
                                domainId, user,isRead);
                if (processedFlowList.size() <= 1) {
                    // 如果该软件没有数据则添加该软件的数据
                    // 大小为1的时候表明只有"全部"这一项
                    continue;
                }
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("carboncopyFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getPendings(String applicationId,
                                           String title, String flowId, String initiatorId,String flowname, Integer pageNo,
                                           Integer linesPerPage, IUser user, boolean isMobile) throws Exception {
        pageNo = pageNo == null || pageNo <= 0 ? 1 : pageNo;
        linesPerPage = linesPerPage == null || linesPerPage <= 0 ? 10
                : linesPerPage;
        RunTimeService<Document> process = new WorkProcessBean(applicationId);
        DataPackage<WorkVO> pendingList = ((WorkProcess) process)
                .getPendingList(title, initiatorId, flowId, true, applicationId,
                        user.getDomainid(),flowname,pageNo, linesPerPage, user);
        Map<String, Object> result = new HashMap<String, Object>();

        List<Object> datasList = new ArrayList<Object>();
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        for (Iterator<WorkVO> iterator = pendingList.datas.iterator(); iterator
                .hasNext(); ) {
            WorkVO workVO = iterator.next();
            Map<String, Object> map = new HashMap<String, Object>();

            String auditorList = workVO.getAuditorList();
            JSONArray auditorListJson = null;
            try {
                //FIXME 兼容旧数据
                if (!StringUtil.isBlank(auditorList)) {
                    auditorListJson = cn.myapps.util.json.JsonTmpUtil.fromObject(auditorList);
                }

                Form form = formService.doView(workVO.getFormId());
                if(form != null){
                    if(!StringUtil.isBlank(form.getDescription())){
                        map.put("formName", form.getDescription());
                    } else {
                        map.put("formName", form.getName());
                    }
                }
            } catch (Exception e) {
            }
            map.put("applicationId", workVO.getApplicationId());
            map.put("auditorList", auditorListJson);
            map.put("auditorNames", workVO.getAuditorNames());
            map.put("initiatorId", workVO.getInitiatorId());
            map.put("initiator", workVO.getInitiator());
            map.put("initiatorDeptId", workVO.getInitiatorDeptId());
            map.put("initiatorDept", workVO.getInitiatorDept());
            map.put("firstProcessTime", workVO.getFirstProcessTime());
            map.put("actionTime", workVO.getActionTime());
            map.put("lastProcessTime", workVO.getLastProcessTime());
            map.put("lastFlowOperation", workVO.getLastFlowOperation());
            map.put("formId", workVO.getFormId());
            map.put("flowName", workVO.getFlowName());
            map.put("flowId", workVO.getFlowId());
            map.put("docId", workVO.getDocId());
            map.put("read", workVO.getRead());
            map.put("stateLabel", workVO.getStateLabel());
            map.put("subject", workVO.getSubject());
            datasList.add(map);
        }
        result.put("datas", datasList);
        result.put("linesPerPage", pendingList.getLinesPerPage());
        result.put("pageCount", pendingList.getPageCount());
        result.put("pageNo", pendingList.getPageNo());
        result.put("rowCount", pendingList.getRowCount());
        return result;
    }

    @Override
    public Map<String, Object> getProcesseds(String applicationId,
                                             String title, String flowId, String initiatorId, boolean isMyWorkFlow,
                                             String status,String flowname, Integer pageNo, Integer linesPerPage,
                                             IUser user) throws Exception {
        // 查询条件
        status = "all".equals(status) ? null : status;

        // 分页数据
        pageNo = pageNo == null || pageNo <= 0 ? 1 : pageNo;
        linesPerPage = linesPerPage == null || linesPerPage <= 0 ? 10
                : linesPerPage;
        RunTimeService<Document> process = new WorkProcessBean(applicationId);
        DataPackage<WorkVO> processedList = ((WorkProcess) process).getProcessedRunningList(title, initiatorId, flowId, applicationId, user.getDomainid(), isMyWorkFlow,
                status,flowname, pageNo, linesPerPage, user);
        Map<String, Object> result = new HashMap<String, Object>();

        List<Object> datasList = new ArrayList<Object>();
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        for (Iterator<WorkVO> iterator = processedList.datas.iterator(); iterator
                .hasNext(); ) {
            WorkVO workVO = iterator.next();
            Map<String, Object> map = new HashMap<String, Object>();

            String auditorList = workVO.getAuditorList();
            JSONArray auditorListJson = null;

            try {
                //FIXME 兼容旧数据
                if (!StringUtil.isBlank(auditorList)) {
                    auditorListJson = cn.myapps.util.json.JsonTmpUtil.fromObject(auditorList);
                }

                Form form = formService.doView(workVO.getFormId());
                if(form != null){
                    if(!StringUtil.isBlank(form.getDescription())){
                        map.put("formName", form.getDescription());
                    } else {
                        map.put("formName", form.getName());
                    }
                }
            } catch (Exception e) {
            }

            map.put("applicationId", workVO.getApplicationId());
            map.put("auditorList", auditorListJson);
            map.put("auditorNames", workVO.getAuditorNames());
            map.put("initiatorId", workVO.getInitiatorId());
            map.put("initiator", workVO.getInitiator());
            map.put("initiatorDeptId", workVO.getInitiatorDeptId());
            map.put("initiatorDept", workVO.getInitiatorDept());
            map.put("firstProcessTime", workVO.getFirstProcessTime());
            map.put("lastProcessTime", workVO.getLastProcessTime());
            map.put("lastFlowOperation", workVO.getLastFlowOperation());
            map.put("formId", workVO.getFormId());
            map.put("flowName", workVO.getFlowName());
            map.put("flowId", workVO.getFlowId());
            map.put("docId", workVO.getDocId());
            map.put("stateLabel", workVO.getStateLabel());
            map.put("subject", workVO.getSubject());
            datasList.add(map);
        }
        result.put("datas", datasList);
        result.put("linesPerPage", processedList.getLinesPerPage());
        result.put("pageCount", processedList.getPageCount());
        result.put("pageNo", processedList.getPageNo());
        result.put("rowCount", processedList.getRowCount());
        return result;
    }
    @Override
    public Map<String, Object> carboncopy(String applicationId,
                                          String title, String flowId, String initiatorId, boolean platformMode,
                                          boolean isRead,String flowname, Integer pageNo, Integer linesPerPage,
                                          IUser user) throws Exception {
        // 查询条件
//        status = "all".equals(status) ? null : status;

        // 分页数据
        pageNo = pageNo == null || pageNo <= 0 ? 1 : pageNo;
        linesPerPage = linesPerPage == null || linesPerPage <= 0 ? 10
                : linesPerPage;
        RunTimeService<Document> process = new WorkProcessBean(applicationId);
        DataPackage<WorkVO> processedList = ((WorkProcess) process).carboncopy(title, initiatorId, flowId, applicationId, user.getDomainid(), platformMode,
                isRead,flowname, pageNo, linesPerPage, user);
        Map<String, Object> result = new HashMap<String, Object>();

        List<Object> datasList = new ArrayList<Object>();
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        for (Iterator<WorkVO> iterator = processedList.datas.iterator(); iterator
                .hasNext(); ) {
            WorkVO workVO = iterator.next();
            Map<String, Object> map = new HashMap<String, Object>();

            String auditorList = workVO.getAuditorList();
            JSONArray auditorListJson = null;

            try {
                //FIXME 兼容旧数据
                if (!StringUtil.isBlank(auditorList)) {
                    auditorListJson = cn.myapps.util.json.JsonTmpUtil.fromObject(auditorList);
                }

                Form form = formService.doView(workVO.getFormId());
                if(form != null){
                    if(!StringUtil.isBlank(form.getDescription())){
                        map.put("formName", form.getDescription());
                    } else {
                        map.put("formName", form.getName());
                    }
                }
            } catch (Exception e) {
            }

            map.put("applicationId", workVO.getApplicationId());
            map.put("auditorList", auditorListJson);
            map.put("auditorNames", workVO.getAuditorNames());
            map.put("initiatorId", workVO.getInitiatorId());
            map.put("initiator", workVO.getInitiator());
            map.put("initiatorDeptId", workVO.getInitiatorDeptId());
            map.put("initiatorDept", workVO.getInitiatorDept());
            map.put("firstProcessTime", workVO.getFirstProcessTime());
            map.put("lastProcessTime", workVO.getLastProcessTime());
            map.put("lastFlowOperation", workVO.getLastFlowOperation());
            map.put("formId", workVO.getFormId());
            map.put("flowName", workVO.getFlowName());
            map.put("flowId", workVO.getFlowId());
            map.put("docId", workVO.getDocId());
            map.put("read", workVO.getRead());
            map.put("stateLabel", workVO.getStateLabel());
            map.put("subject", workVO.getSubject());
            datasList.add(map);
        }
        result.put("datas", datasList);
        result.put("linesPerPage", processedList.getLinesPerPage());
        result.put("pageCount", processedList.getPageCount());
        result.put("pageNo", processedList.getPageNo());
        result.put("rowCount", processedList.getRowCount());
        return result;
    }

    private String getTotalRowByResource(ResourceVO resource, ParamsTable params, IUser user){
        try {
            if(resource.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())){
                if(resource.getActionContent()==null || resource.getActionContent().equals("")){
                    return "0";
                }
                ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
                AbstractView view = vProcess.doView(resource.getActionContent());
                if (view != null) {
                    long count = view.getViewTypeImpl().countViewDatas(params, user, new Document());
                    return String.valueOf(count);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "0";
    }

    @SuppressWarnings("rawtypes")
    private class MyCompartor2 implements Comparator {

        @Override
        public int compare(Object o1, Object o2) {
            StartMenuNode c1 = (StartMenuNode) o1;
            StartMenuNode c2 = (StartMenuNode) o2;
            return c2.getOrderNo().compareTo(c1.getOrderNo());
        }
    }
}
