package cn.myapps.runtime.flowcenter.service;

import java.util.List;
import java.util.Map;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.model.resource.StartMenuNode;

/**
 * 流程中心运行时服务接口
 * @author spy
 */
public interface FlowCenterRumTimeService{

	/**
	 * 获取发起菜单
	 * @param applicationId
	 * 		软件id
	 * @param isMobile
	 * 		是否移动端
	 * @param isUsual
	 * 		是否常用
	 * @param isUsualList
	 * 		是否常用的添加列表
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * 		发起菜单数据
	 * @throws Exception
	 */
	List<StartMenuNode> getStartMenus(String applicationId, boolean isMobile, boolean isUsual, boolean isUsualList, IUser user) throws Exception;

	/**
	 * 获取待办导航
	 * @param applicationId
	 * 		软件id
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * 		待办导航栏数据
	 * @throws Exception
	 */
	List<Map<String, Object>> getPendingNavs(String applicationId, IUser user)
			throws Exception;

	/**
	 * 获取经办导航
	 * @param applicationId
	 * 		软件id
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * 		经办导航栏数据
	 * @throws Exception
	 */
	List<Map<String, Object>> getProcessedNavs(String applicationId,
			IUser user) throws Exception;

	/**
	 * 获取抄送导航
	 * @param applicationId
	 * 		软件id
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * 		经办导航栏数据
	 * @throws Exception
	 */
	List<Map<String, Object>> getCarboncopyNavs(String applicationId,
												IUser user,boolean isRead) throws Exception;

	/**
	 * 获取待办列表
	 * @param applicationId
	 * 		软件id
	 * @param title
	 * 		标题
	 * @param flowId
	 * 		流程id
	 * @param initiatorId
	 * 		申请人
	 * @param pageNo
	 * 		当前页
	 * @param linesPerPage
	 * 		每页显示条数
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * 		待办列表数据
	 * @throws Exception
	 */
	Map<String, Object> getPendings(String applicationId, String title, String flowId, String initiatorId,String flowname,
			Integer pageNo, Integer linesPerPage, IUser user, boolean isMobile)
					throws Exception;

	/**
	 * 获取经办列表
	 * @param applicationId
	 * 		软件id
	 * @param title
	 * 		标题
	 * @param flowId
	 * 		流程id
	 * @param initiatorId
	 * 		申请人
	 * @param isMyWorkFlow
	 * 		是否自己发起
	 * @param isComplete
	 * 		是否已完成
	 * @param pageNo
	 * 		当前页
	 * @param linesPerPage
	 * 		每页显示条数
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * 		经办列表数据
	 * @throws Exception
	 */
	Map<String, Object> getProcesseds(String applicationId, String title, String flowId, String initiatorId, boolean isMyWorkFlow,
			String status,String flowname, Integer pageNo, Integer linesPerPage,
			IUser user) throws Exception;

	/**
	 * 获取抄送数据
	 * @param applicationId
	 * 		软件id
	 * @param title
	 * 		标题
	 * @param flowId
	 * 		流程id
	 * @param initiatorId
	 * 		申请人
	 * @param platformMode
	 * 		是否已读
	 * @param isRead
	 * 		是否已完成
	 * @param pageNo
	 * 		当前页
	 * @param linesPerPage
	 * 		每页显示条数
	 * @param user
	 * 		当前登陆用户对象
	 * @return
	 * 		获取抄送数据
	 * @throws Exception
	 */
	public Map<String, Object> carboncopy(String applicationId,
										  String title, String flowId, String initiatorId, boolean platformMode,
										  boolean isRead,String flowname, Integer pageNo, Integer linesPerPage,
										  IUser user) throws Exception;
}
