package cn.myapps.runtime.dynaform.work.ejb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.runtime.common.service.AbstractRunTimeServiceImpl;
import cn.myapps.runtime.dynaform.document.dao.DocumentDAO;
import cn.myapps.runtime.dynaform.document.ejb.WorkVO;
import cn.myapps.util.RuntimeDaoManager;

public class WorkProcessBean extends AbstractRunTimeServiceImpl implements WorkProcess{

//	@Override
	protected DocumentDAO getDAO() throws Exception {
		return RuntimeDaoManager.getDocStaticTblDAO(getConnection());
	}


	public WorkProcessBean(String applicationId) {
		super(applicationId);
	}

	@Override
	public Collection<Map<String,Object>> getPendingFlowList(boolean isFlowAgent ,String applicationId, String domainId, IUser user) throws Exception {
		setApplicationId(applicationId);
		DocumentDAO dao = ((DocumentDAO) getDAO());
		if (dao == null) {
			return new ArrayList<>();
		}

		return dao.getPendingFlowList(isFlowAgent, applicationId, domainId, user);
	}

	@Override
	public DataPackage<WorkVO> getPendingList(String title, String initiatorId,
			String flowId, boolean isFlowAgent, String applicationId,
			String domainId,String flowname, int pageNo, int linesPerPage, IUser user)
			throws Exception {
		setApplicationId(applicationId);
		return ((DocumentDAO)getDAO()).getPendingList(title,initiatorId,flowId,isFlowAgent,applicationId,domainId,flowname,pageNo,linesPerPage ,user);
	}

	@Override
	public Collection<Map<String,Object>> getProcessedRunningFlowList(String applicationId, String domainId, IUser user) throws Exception {
		setApplicationId(applicationId);
		return ((DocumentDAO)getDAO()).getProcessedRunningFlowList(applicationId,domainId,user);
	}

	@Override
	public Collection<Map<String,Object>> getCarboncopyRunningFlowList(String applicationId, String domainId, IUser user,boolean isRead) throws Exception {
		setApplicationId(applicationId);
		return ((DocumentDAO)getDAO()).getCarboncopyRunningFlowList(applicationId,domainId,user,isRead);
	}

	@Override
	public DataPackage<WorkVO> getProcessedRunningList(String title,
			String initiatorId, String flowId, String applicationId,
			String domainId, boolean isMyWorkFlow, String status,String flowname, int pageNo, int linesPerPage, IUser user)
			throws Exception {
		setApplicationId(applicationId);
        return ((DocumentDAO) getDAO()).getProcessedRunningList(title, initiatorId, flowId, applicationId, domainId,
                isMyWorkFlow, status,flowname, pageNo, linesPerPage, user);
	}

	@Override
	public DataPackage<WorkVO> carboncopy(String title,
										  String initiatorId, String flowId, String applicationId,
										  String domainId, boolean platformMode, boolean isRead,String flowname, int pageNo, int linesPerPage, IUser user)
			throws Exception {
		setApplicationId(applicationId);
		return ((DocumentDAO) getDAO()).carboncopy(title, initiatorId, flowId, applicationId, domainId,
				platformMode, isRead,flowname, pageNo, linesPerPage, user);
	}

}
